% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mlp_net.R
\name{mlp_export_C}
\alias{mlp_export_C}
\title{Export multilayer perceptron network to a C function}
\usage{
mlp_export_C(net, fname, A = NULL, b = NULL, C = NULL, d = NULL)
}
\arguments{
\item{net}{an object of \code{mlp_net} class}

\item{fname}{character string with the filename}

\item{A}{numeric matrix (optional), input linear transformation}

\item{b}{numeric vector (optional), input translation}

\item{C}{numeric matrix (optional), output linear transformation}

\item{d}{numeric vector (optional), output translation}
}
\value{
Logical value, TRUE if export was successful, FALSE otherwise.
}
\description{
This function exports multilayer perceptron network to a C function
with optional affine input and output transformations: Ax+b for inputs
and Cx+d for outputs.
}
\examples{
# create a 2-3-1 network
net <- mlp_net(c(2, 3, 1))
# randomise weights
net <- mlp_rnd_weights(net)
# show the network
show(net)
# export network to a C function
mlp_export_C(net, "test.c")
# show the output file
file.show("test.c")
}

