% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlp_net.R
\name{mlp_net-absolute-weight-indices}
\alias{mlp_get_w_abs_idx}
\alias{mlp_get_w_idx}
\alias{mlp_net-absolute-weight-indices}
\title{Retrieving absolute weight index}
\usage{
mlp_get_w_idx(net, layer, nidx, nplidx)

mlp_get_w_abs_idx(net, idx)
}
\arguments{
\item{net}{an object of \code{mlp_net} class}

\item{layer}{integer value (vector), layer index}

\item{nidx}{integer value (vector), neuron index}

\item{nplidx}{integer value (vector), index of the neuron in the previous
layer determining connection from neuron \code{nidx}
in \code{layer}, 0 denotes bias of neuron \code{nidx} in \code{layer}}

\item{idx}{integer value (vector), weight index (indices) within active ones}
}
\value{
Absolute weight index.
}
\description{
In some situations absolute weight index (i.e. index within all weights
including inactive ones) needs to be computed based on information
about connected neurons' indices or weight index within actives ones.
The latter functionality is especially useful in implementation of pruning
algorithms.
}

