% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCVAR_spec.R
\name{FCVARrankTests}
\alias{FCVARrankTests}
\title{Test for Cointegrating Rank}
\usage{
FCVARrankTests(x, k, opt)
}
\arguments{
\item{x}{A matrix of variables to be included in the system.}

\item{k}{The number of lags in the system.}

\item{opt}{An S3 object of class \code{FCVAR_opt} that stores the chosen estimation options,
generated from \code{FCVARoptions()}.}
}
\value{
An S3 object of type \code{FCVAR_ranks} containing the results
from cointegrating rank tests, containing the following \code{(p+1)} vectors
with \code{i}th element corresponding to \code{rank = i-1},
including the following parameters:
\describe{
  \item{\code{dHat}}{Estimates of \code{d}.}
  \item{\code{bHat}}{Estimates of \code{b}.}
  \item{\code{LogL}}{Maximized log-likelihood.}
  \item{\code{LRstat}}{LR trace statistic for testing rank \code{r} against rank \code{p}.}
  \item{\code{pv}}{The p-value of LR trace test, or "999" if p-value is not available.}
  \item{\code{k}}{The number of lags in the system.}
  \item{\code{p}}{The number of variables in the system.}
  \item{\code{cap_T}}{The sample size.}
  \item{\code{opt}}{An S3 object of class \code{FCVAR_opt} that stores the chosen estimation options,
    generated from \code{FCVARoptions()}.}
}
}
\description{
\code{FCVARrankTests} performs a sequence of  likelihood ratio tests
	for cointegrating rank.
}
\examples{
\donttest{
opt <- FCVARoptions()
opt$gridSearch   <- 0 # Disable grid search in optimization.
opt$dbMin        <- c(0.01, 0.01) # Set lower bound for d,b.
opt$dbMax        <- c(2.00, 2.00) # Set upper bound for d,b.
opt$constrained  <- 0 # Impose restriction dbMax >= d >= b >= dbMin ? 1 <- yes, 0 <- no.
x <- votingJNP2014[, c("lib", "ir_can", "un_can")]
rankTestStats <- FCVARrankTests(x, k = 2, opt)
}
}
\seealso{
\code{FCVARoptions} to set default estimation options.
\code{FCVARestn} is called repeatedly within this function
for each candidate cointegrating rank.
\code{summary.FCVAR_ranks} prints a summary of the output of \code{FCVARrankTests} to screen.

Other FCVAR specification functions: 
\code{\link{FCVARbootRank}()},
\code{\link{FCVARlagSelect}()},
\code{\link{summary.FCVAR_lags}()},
\code{\link{summary.FCVAR_ranks}()}
}
\concept{FCVAR specification functions}
