% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesize.R
\name{n.fdr.coxph}
\alias{n.fdr.coxph}
\title{Sample size calculation for the Cox proportional hazards regression model}
\usage{
n.fdr.coxph(fdr, pwr, logHR, v, pi0.hat = "BH")
}
\arguments{
\item{fdr}{desired FDR (scalar numeric)}

\item{pwr}{desired average power (scalar numeric)}

\item{logHR}{log hazard ratio (vector)}

\item{v}{variance of predictor variable (vector)}

\item{pi0.hat}{approximation method for null proportion}
}
\value{
A list with the following components:
\item{n}{a sample size estimate}
\item{computed.avepow}{average power}
\item{desired.avepow}{desired average power}
\item{desired.fdr}{desired FDR}
\item{input.pi0}{proportion of tests with a true null hypothesis}
\item{alpha}{fixed p-value threshold for multiple testing procedure}
\item{n.its}{number of iteration}
\item{max.its}{maximum number of iteration, default is 50}
\item{n0}{lower limit for initial sample size range}
\item{n1}{upper limit for initial sample size range}
}
\description{
Find number of events needed to have a desired false discovery rate and average power for a large number of Cox regression models with non-binary covariates.
}
\examples{
log.HR=log(rep(c(1,2),c(900,100)))
v=rep(1,1000)
n.fdr.coxph(fdr=0.1, pwr=0.8,logHR=log.HR, v=v, pi0.hat="BH")
}
\references{
Hsieh, FY and Lavori, Philip W (2000) Sample-size calculations for the Cox proportional hazards regression model with non-binary covariates. Controlled Clinical Trials 21(6):552-560.
}
