% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmatrix.R
\name{hmatrix}
\alias{hmatrix}
\title{A S3 class for univariate functional data on a common grid}
\usage{
hmatrix(
  time,
  id,
  x,
  argvals = 1:ncol(x),
  timeLab = "t",
  idLab = "wideIndex",
  xLab = "x",
  argvalsLab = "s"
)
}
\arguments{
\item{time}{set of argument values of the response in long format, 
i.e. at which \code{t} the response curve is observed}

\item{id}{specify to which curve the point belongs to, id from 1, 2, ..., n.}

\item{x}{matrix of functional covariate, each trajectory is in one row}

\item{argvals}{set of argument values, i.e., the common gird at which the functional covariate 
is observed, by default \code{1:ncol(x)}}

\item{timeLab}{name of the time axis, by default \code{t}}

\item{idLab}{name of the id variable, by default \code{wideIndex}}

\item{xLab}{name of the functional variable, by default NULL}

\item{argvalsLab}{name of the argument for the covariate by default \code{s}}
}
\description{
The hmatrix class represents data for a functional historical effect. 
The class is basically a matrix containing the time and the id for the observations of the 
functional response. The functional covariate is contained as attribute.
}
\details{
In the hmatrix class the id has to run from i=1, 2, ..., n including all integers from 1 to n. 
The rows of the functional covariate x correspond to those observations.
}
\examples{
## Example for a hmatrix object
t1 <- rep((1:5)/2, each = 3)
id1 <- rep(1:3, 5)
x1 <- matrix(1:15, ncol = 5) 
s1 <- (1:5)/2 
myhmatrix <- hmatrix(time = t1, id = id1, x = x1, argvals = s1, 
                     timeLab = "t1", argvalsLab = "s1", xLab = "test")

# extract with [ keeps attributes 
# select observations of subjects 2 and 3
myhmatrixSub <- myhmatrix[id1 \%in\% c(2, 3), ]  
str(myhmatrixSub)
getX(myhmatrixSub)
getX(myhmatrix)

# get time
myhmatrix[ , 1] # as column matrix as drop = FALSE
getTime(myhmatrix) # as vector

# get id
myhmatrix[ , 2] # as column matrix as drop = FALSE
getId(myhmatrix) # as vector

# subset hmatrix on the basis of an index, which is defined on the curve level
reweightData(data = list(hmat = myhmatrix), vars = "hmat", index = c(1, 1, 2))
# this keeps only the unique x values in attr(,'x') but multiplies the corresponding
# ids and times in the time id matrix 
# for bhistx baselearner, there may be an additional id variable for the tensor product
newdat <- reweightData(data = list(hmat = myhmatrix, 
  repIDx = rep(1:nrow(attr(myhmatrix,'x')), length(attr(myhmatrix,"argvals")))), 
  vars = "hmat", index = c(1,1,2), idvars="repIDx")
length(newdat$repIDx) 

## use hmatrix within a data.frame
mydat <- data.frame(I(myhmatrix), z=rnorm(3)[id1])
str(mydat)
str(mydat[id1 \%in\% c(2, 3), ])
str(myhmatrix[id1 \%in\% c(2, 3), ])
 
}
\seealso{
\code{\link{getTime.hmatrix}} to extract attributes, 
and ?"[.hmatrix" for the extract method.
}
