% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApplyBC.R
\name{ApplyBC}
\alias{ApplyBC}
\title{ApplyBC}
\usage{
ApplyBC(meshP, BoundConx, BoundCony)
}
\arguments{
\item{meshP}{Matrix (2 x n) containing coordinate points of the mesh}

\item{BoundConx}{Boundary constraint for nodes in the x-direction}

\item{BoundCony}{Boundary constraint for nodes in the y-direction}
}
\value{
A data frame with constraint parameters applied to each node in the x and y directions. Formatted for use in reduced element matrix.
\item{NodeKnownL}{Constraint parameters}
}
\description{
Boundary constraint for element centroids based on coordinate points. For the x & y direction per centroid create matrix with boundary 1(unfixed) or 0(fixed).
}
\examples{
data(triMesh)

meshP = triMesh$MeshPts$p
BoundConx = BoundCony = numeric(NROW(meshP))
BoundConx[1:NROW(meshP)] = BoundCony[1:NROW(meshP)] = 1
BoundConx[c(10, 11, 12)] = BoundCony[c(10, 11, 12)] = 0

bound = ApplyBC(meshP, BoundConx, BoundCony)

}
