% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ElementMat.R
\name{ElementMat}
\alias{ElementMat}
\title{ElementMat}
\usage{
ElementMat(meshP, meshT, Nu, Y, Thick)
}
\arguments{
\item{meshP}{Matrix (2 x n) containing coordinate points of the mesh nodes.}

\item{meshT}{Matrix (3 x n) containing the number of the coordinate point that forms a given triangle within the mesh.}

\item{Nu}{Value of Poisson's ratio for each element}

\item{Y}{Value of Young's (Elastic) modulus for each element}

\item{Thick}{Value of the thickness of the mesh, a positive value must be given.}
}
\value{
Generates initial element matrix needed for the finite element model.
\item{EMPStress}{An element matrix of the geometry under stress.}
\item{EMPStrain}{An element matrix of the geometry under strain.}
}
\description{
Generates an element stiffness matrix
}
\examples{
data(triMesh)

meshP = triMesh$MeshPts$p
meshT = triMesh$MeshPts$T
Y = matrix(20e9, nrow = NROW(meshT))
Nu = matrix(0.45, nrow = NROW(meshT))
Thick = 0.001
DOF = 6

fea_EM = ElementMat(meshP, meshT, Nu, Y, Thick)

}
