% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompleteFEMStrain.R
\name{FEMStrain}
\alias{FEMStrain}
\title{FEMStrain}
\usage{
FEMStrain(meshP, meshT, centroid, BoundConx, BoundCony, SFShear,
SFTensile, Length, area, Fx, Fy, Y, Nu, Thick)
}
\arguments{
\item{meshP}{Matrix (2 x n) containing coordinate points of the mesh nodes.}

\item{meshT}{Matrix (3 x n) containing the number of the coordinate point that forms a given triangle within the mesh.}

\item{centroid}{Matrix (2 x n) containing coordinate points of the centroid of each triangular element.}

\item{BoundConx}{Boundary constraint for nodes in the x-direction}

\item{BoundCony}{Boundary constraint for nodes in the y-direction}

\item{SFShear}{Magnitude of positive shear traction; if there is no surface traction then SFShear = 0}

\item{SFTensile}{Magnitude of tensile surface traction; if there is no surface traction then SFTensile = 0}

\item{Length}{Truss length}

\item{area}{Triangle element area}

\item{Fx}{Load vector for the x-direction}

\item{Fy}{Load vector for the y-direction}

\item{Y}{Value of Young's (Elastic) modulus}

\item{Nu}{Value of Poisson's ratio}

\item{Thick}{Value of the thickness of the mesh, a value must be given.}
}
\value{
Completes the FEM to generate values of stress and strain and nodal displacement.
\item{NodeDisplacement}{Node displacement on each axis}
\item{LocalStress}{Stress as calucated from stress, strain, and stress from strain. Three (3) [3 x n] matrices where [x, y, tau]}
}
\description{
Creates a complete finite element model using strain for a given 2D mesh under specified boundary conditions (constrain and load).
}
\examples{
\donttest{
data(triMesh)
data(dime)

meshP = triMesh$MeshPts$p
meshT = triMesh$MeshPts$T
centroid = triMesh$Centroids
Y = matrix(20e9, nrow = NROW(meshT))
Nu = matrix(0.45, nrow = NROW(meshT))
Thick = 0.001
DOF = 6
BoundConx = BoundCony = numeric(NROW(meshP))
BoundConx[1:NROW(meshP)] = BoundCony[1:NROW(meshP)] = 1
BoundConx[c(10, 11, 12)] = BoundCony[c(10, 11, 12)] = 0
SFShear = 0
SFTensile = 0
Length = dime$TrussLength
area = dime$Area
Fx = 10
Fy = 10

fea_strain = FEMStrain(meshP, meshT, centroid, BoundConx, BoundCony, SFShear, SFTensile,
             Length, area, Fx, Fy, Y, Nu, Thick)


PlotVal = abs(fea_strain$LocalStress$Stress[,1])
Oc = "slateblue"; ac = "steelblue2"; bc = "cyan2"; cc = "palegreen2";
dc = "darkolivegreen1"; ec = "lemonchiffon"; fc = "lightgoldenrod1"; gc = "gold";
hc= "lightsalmon"; ic= "tomato"; jc= "firebrick3"
a = 1e5;  b = 5e5;  c = 1e6;  d = 5e6;  e = 1e7;  f = 5e7;  g = 1e8;  h = 5e8; i = 1e9; j =5e9

PlotSystem(meshP, meshT, PlotVal, a, b, c, d, e, f, g, h, i, j,
           Oc, ac, bc, cc, dc, ec, fc, gc, hc, ic, jc)
}

}
