% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cev_price.R
\name{CevPrice}
\alias{CevPrice}
\title{Calculate the constant elasticity of variance (CEV) model option price}
\usage{
CevPrice(
  strike = forward,
  spot,
  texp = 1,
  sigma,
  beta = 0.5,
  intr = 0,
  divr = 0,
  cp = 1L,
  forward = spot * exp(-divr * texp)/df,
  df = exp(-intr * texp)
)
}
\arguments{
\item{strike}{(vector of) strike price}

\item{spot}{(vector of) spot price}

\item{texp}{(vector of) time to expiry}

\item{sigma}{(vector of) volatility}

\item{beta}{beta}

\item{intr}{interest rate}

\item{divr}{dividend rate}

\item{cp}{call/put sign. \code{1} for call, \code{-1} for put.}

\item{forward}{forward price. If given, \code{forward} overrides \code{spot}}

\item{df}{discount factor. If given, \code{df} overrides \code{intr}}
}
\value{
option price
}
\description{
Calculate the constant elasticity of variance (CEV) model option price
}
\examples{
spot <- 100
strike <- seq(80,125,5)
texp <- 1.2
beta <- 0.5
sigma <- 2
FER::CevPrice(strike, spot, texp, sigma, beta)

}
\references{
Schroder, M. (1989). Computing the constant elasticity
  of variance option pricing formula. Journal of Finance,
  44(1), 211-219. https://doi.org/10.1111/j.1540-6261.1989.tb02414.x
}
