% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cuerank_function.R
\name{cuerank}
\alias{cuerank}
\title{Calculate the accuracy of all cues in a dataframe}
\usage{
cuerank(cue.df = NULL, criterion.v = NULL, tree.criterion = "v",
  numthresh.method = "o", hr.weight = 0.5, correction = 0.25,
  rounding = NULL, verbose = F)
}
\arguments{
\item{cue.df}{A dataframe of cue values}

\item{criterion.v}{A logical vector of length m containing criterion values for exemplars in cue.df}

\item{tree.criterion}{A string indicating how to rank cues. "v" = HR - FAR, "d" = d-prime.}

\item{numthresh.method}{A string indicating how to calculate cue splitting thresholds. "m" = median split, "o" = split that maximizes the tree criterion.}

\item{hr.weight}{A number between 0 and 1 indicating how much weight to give to increasing hit rates versus avoiding false alarms. 1 means maximizing HR and ignoring FAR, while 0 does the opposite. The default of 0.5 gives equal weight to both.}

\item{correction}{If any classification cells are empty, this number is added to all cells when calculating d-prime. Default is 0.25.}

\item{rounding}{An integer indicating digit rounding for non-integer numeric cue thresholds. The default is NULL which means no rounding. A value of 0 rounds all possible thresholds to the nearest integer, 1 rounds to the nearest .1 (etc.).}

\item{verbose}{A logical value indicating whether or not to print ongoing diagnostics}
}
\value{
A list with two elements. The first, "cue.stats" is a dataframe containing the classification statistics for every possible cue threshold. The second element, cue.best, contains data for the best performing cue threshold
}
\description{
Calculate the accuracy of all cues in a dataframe
}

