% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictFFTrees_function.R
\name{predict.FFTrees}
\alias{predict.FFTrees}
\title{Predict new data from an FFTrees x}
\usage{
\method{predict}{FFTrees}(object = NULL, data = NULL, tree = "best.train",
  ...)
}
\arguments{
\item{object}{An FFTrees object created from the FFTrees() function.}

\item{data}{A dataframe of test data}

\item{tree}{Which tree in the FFTrees x should be used? Can be an integer or "best.train" (the default) to use the tree with the best training statistics.}

\item{...}{Additional arguments passed on to \code{predict()}}
}
\value{
A logical vector of predictions
}
\description{
Predict new data from an FFTrees x
}
\examples{


  # Create training and test data

  set.seed(100)
  breastcancer <- breastcancer[sample(nrow(breastcancer)),]
  breast.train <- breastcancer[1:150,]
  breast.test <- breastcancer[151:303,]

  # Create an FFTrees x from the training data

  breast.fft <- FFTrees(formula = diagnosis ~.,
                              data = breast.train)

 # Predict results for test data
  breast.fft.pred <- predict(breast.fft,
                             data = breast.test)

}
