% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applytree_function.R
\name{apply.tree}
\alias{apply.tree}
\title{Applies a fast-and-frugal tree to a dataset and generates several accuracy statistics}
\usage{
apply.tree(data, formula, tree.definitions, sens.w = 0.5,
  cost.outcomes = c(0, 1, 1, 0), cost.cues = NULL, allNA.pred = FALSE)
}
\arguments{
\item{data}{dataframe. A model training dataset. An m x n dataframe containing n cue values for each of the m exemplars.}

\item{formula}{A formula}

\item{tree.definitions}{dataframe. Definitions of one or more trees. The dataframe must contain the columns: cues, classes, thresholds, directions, exits.}

\item{sens.w}{numeric.  A number from 0 to 1 indicating how to weight sensitivity relative to specificity. Only used for calculating wacc values.}

\item{cost.outcomes}{numeric. A vector of length 4 specifying the costs of a hit, false alarm, miss, and correct rejection rspectively. E.g.; \code{cost.outcomes = c(0, 10, 20, 0)} means that a false alarm and miss cost 10 and 20 respectively while correct decisions have no cost.}

\item{cost.cues}{dataframe. A dataframe with two columns specifying the cost of each cue. The first column should be a vector of cue names, and the second column should be a numeric vector of costs. Cues in the dataset not present in \code{cost.cues} are assume to have 0 cost.}

\item{allNA.pred}{logical. What should be predicted if all cue values in tree are NA? Default is FALSE}
}
\value{
A list of length 4 containing
}
\description{
Applies a fast-and-frugal tree to a dataset and generates several accuracy statistics
}
