% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFFTrees_function.R
\name{plot.FFTrees}
\alias{plot.FFTrees}
\title{Plot an \code{FFTrees} object}
\usage{
\method{plot}{FFTrees}(
  x = NULL,
  data = "train",
  what = "tree",
  tree = 1,
  main = NULL,
  cue.labels = NULL,
  decision.labels = NULL,
  cue.cex = NULL,
  threshold.cex = NULL,
  decision.cex = 1,
  comp = TRUE,
  stats = TRUE,
  show.header = NULL,
  show.tree = NULL,
  show.confusion = NULL,
  show.levels = NULL,
  show.roc = NULL,
  show.icons = NULL,
  show.iconguide = NULL,
  hlines = TRUE,
  label.tree = NULL,
  label.performance = NULL,
  n.per.icon = NULL,
  which.tree = NULL,
  level.type = "bar",
  decision.names = NULL,
  ...
)
}
\arguments{
\item{x}{An \code{FFTrees} object created by the \code{\link{FFTrees}} function.}

\item{data}{The data in \code{x} to be plotted (as a string);
must be either \code{'train'} (for fitting performance) or \code{'test'} (for prediction performance).
By default, \code{data = 'train'} (as \code{x} may not contain test data).}

\item{what}{What should be plotted (as a string)?
\code{'tree'} (the default) shows details of one tree (specified by \code{tree});
\code{'cues'} shows the marginal accuracy of cues in ROC space;
\code{'roc'} shows the performance of tree(s) (and comparison algorithms) in ROC space.}

\item{tree}{The tree to be plotted (as an integer, only valid when the corresponding tree argument is non-empty).
Default: \code{tree = 1}.
To plot the best training or best test tree with respect to the \code{goal} specified during FFT construction,
use \code{"best.train"} or \code{"best.test"}, respectively.}

\item{main}{The main plot label (as a character string).}

\item{cue.labels}{An optional string of labels for the cues / nodes (as character vector).}

\item{decision.labels}{A character vector of length 2 indicating the content-specific names for noise and signal predictions/exits.}

\item{cue.cex}{The size of the cue labels (as numeric).}

\item{threshold.cex}{The size of the threshold labels (as numeric).}

\item{decision.cex}{The size of the decision labels (as numeric).}

\item{comp}{Should the performance of competitive algorithms (e.g.; logistic regression, random forests, etc.)
be shown in the ROC plot (if available, as logical)?}

\item{stats}{Should statistical information be plotted (as logical)?
If \code{FALSE}, only the tree diagram (without any reference to statistics) will be plotted.}

\item{show.header}{Show header with basic data properties (in top panel, as logical)?}

\item{show.tree}{Show nodes and exits of FFT (in middle panel, as logical)?}

\item{show.confusion}{Show 2x2 confusion matrix (in bottom panel, as logical)?}

\item{show.levels}{Show performance levels (in bottom panel, as logical)?}

\item{show.roc}{Show ROC curve (in bottom panel, as logical)?}

\item{show.icons}{Show exit cases as icon arrays (in middle panel, as logical)?}

\item{show.iconguide}{Show icon guide (in middle panel, as logical)?}

\item{hlines}{Show horizontal panel separation lines (as logical)?
Default: \code{hlines = TRUE}.}

\item{label.tree}{Label for the FFT (optional, as character string).}

\item{label.performance}{Labels for the performance section (optional, as character string).}

\item{n.per.icon}{Number of cases per icon (as numeric).}

\item{which.tree}{deprecated argument, included for backwards compatibility, use \code{"tree"} instead.}

\item{level.type}{How should bottom levels be drawn (as a string)? Can be \code{"bar"} (the default) or \code{"line"}.}

\item{decision.names}{deprecated argument.}

\item{...}{Graphical parameters (passed either
to \code{\link{showcues}} when \code{what = 'cues'} or
to \code{\link{title}} when \code{what = 'roc'}).}
}
\value{
A plot visualizing and describing an FFT.
}
\description{
\code{plot.FFTrees} visualizes an \code{FFTrees} object created by the \code{\link{FFTrees}} function.

\code{plot.FFTrees} is the main plotting function of the \strong{FFTrees} package and
called when evaluating the generic \code{\link{plot}} on an \code{FFTrees} object.

\code{plot.FFTrees} visualizes a selected FFT, key data characteristics, and various aspects of classification performance.

As \code{x} may not contain test data, \code{plot.FFTrees} by default plots the performance characteristics
for training data (i.e., fitting), rather than for test data (i.e., for prediction).
When test data is available, specifying \code{data = "test"} plots prediction performance.

Whenever the sensitivity weight (\code{sens.w}) is set to its default of \code{sens.w = 0.50},
a level shows \emph{balanced} accuracy (\code{bacc}). If, however, \code{sens.w} deviates from its default,
the level shows the tree's \emph{weighted} accuracy value (\code{wacc}) and the current \code{sens.w} value (below the level).

Many aspects of the plot (e.g., its panels) and the FFT's appearance (e.g., labels of its nodes and exits)
can be customized by setting corresponding arguments.
}
\examples{
# Create FFTs (for heartdisease data):
heart.fft <- FFTrees(formula = diagnosis ~ .,
                     data = heartdisease
                     )

# Visualize the default FFT (Tree #1):
plot(heart.fft,
     main = "Heart Disease Diagnosis",
     decision.labels = c("Absent", "Present")
     )

# Visualize FFT #2 (with customized labels):
plot(heart.fft,
     tree = 2,
     main = "An FFT for heart disease diagnosis",
     cue.labels = c("1. thal?", "2. cp?", "3. ca?", "4. exang"),
     decision.labels = c("ok", "sick"),
     show.header = FALSE,
     show.confusion = FALSE,
     show.levels = FALSE,
     show.roc = FALSE
     )

# Visualize cue accuracies:
plot(heart.fft, what = "cues")

# For more details, see
vignette("FFTrees_plot", package = "FFTrees")

}
\seealso{
\code{\link{showcues}} for plotting cue accuracies;
\code{\link{print.FFTrees}} for printing FFTs;
\code{\link{summary.FFTrees}} for summarizing FFTs;
\code{\link{FFTrees}} for creating FFTs from and applying them to data.

Other plot functions: 
\code{\link{showcues}()}
}
\concept{plot functions}
