\name{tacvfARFIMA}
\alias{tacvfARFIMA}
\title{
	The theoretical autocovariance function of a long memory process.
}
\description{
	Calculates the tacvf of a mixed long memory-ARMA (with posible seasonal components).  
	Combines long memory and ARMA (and non-seasonal and seasonal) parts via convolution.
}
\usage{
tacvfARFIMA(phi = numeric(0), theta = numeric(0), dfrac = numeric(0), 
	phiseas = numeric(0), thetaseas = numeric(0), 
	dfs = numeric(0), H = numeric(0), Hs = numeric(0), alpha = numeric(0),
	alphas = numeric(0), period = 0, maxlag,
	useCt = T, sigma2 = 1)
}

\arguments{
  \item{phi}{
	The autoregressive parameters in vector form. 
}
  \item{theta}{
	The moving average parameters in vector form.  See Details for differences from \code{\link{arima}}.
}

  \item{dfrac}{
	The fractional differencing parameter. 
}
  \item{phiseas}{
	The seasonal autoregressive parameters in vector form. 
}

  \item{thetaseas}{
	The seasonal moving average parameters in vector form.  See Details for differences from \code{\link{arima}}.
}

  \item{dfs}{
	The seasonal fractional differencing parameter. 
}

  \item{H}{
	The Hurst parameter for fractional Gaussian noise (FGN).  Should not be mixed with \code{dfrac} or \code{alpha}:  see "Details".
}

  \item{Hs}{
	The Hurst parameter for seasonal fractional Gaussian noise (FGN).  Should not be mixed with \code{dfs} or \code{alphas}:  see "Details".
}
  \item{alpha}{
	The decay parameter for power-law autocovariance (PLA) noise.  Should not be mixed with \code{dfrac} or \code{H}:  see "Details".
}

  \item{alphas}{
	The decay parameter for seasonal power-law autocovariance (PLA) noise.  Should not be mixed with \code{dfs} or \code{Hs}:  see "Details".
}
  \item{period}{
	The periodicity of the seasonal components.  Must be >= 2.
}

  \item{maxlag}{
	The number of terms to compute: technically the output sequence is from lags 0 to maxlag, so there are maxlag + 1 terms.
}

  \item{useCt}{
	Whether or not to use C to compute the (parts of the) tacvf.
}

  \item{sigma2}{
   variance corresponding to unit innovation variance
}

}
\details{
	The log-likelihood is computed for the given series z and the parameters.  If two or more of \code{dfrac}, \code{H} or \code{alpha} are present and/or 
	two or more of \code{dfs}, \code{Hs} or \code{alphas} are present, an error will be thrown, as otherwise there is redundancy in the model.  
	Note that non-seasonal and seasonal components can be of different types: for example, there can be seasonal FGN with FDWN at the non-seasonal level.
	
	The moving average parameters are in the Box-Jenkins convention: they are the negative of the parameters given by \code{\link{arima}}. 
}
\value{
	A sequence of length maxlag + 1 (lags 0 to maxlag) of the tacvf of the given process.
}

\references{
Veenstra, J. and McLeod, A. I. (Working Paper).
The arfima R package: Exact Methods for Hyperbolic Decay Time Series

P. Borwein (1995)
An efficient algorithm for Riemann Zeta function 
Canadian Math. Soc. Conf. Proc., 27, pp. 29-34.
}

\author{
Justin Veenstra and A. I. McLeod
}

\examples{
tacvfARFIMA(phi = c(0.2, 0.1), theta = 0.4, dfrac = 0.3, maxlag = 30)

}

\keyword{ ts }