% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBgetStrata.R
\name{DBgetStrata}
\alias{DBgetStrata}
\title{Database - Gets stratification information from FIA database.}
\usage{
DBgetStrata(
  dat = NULL,
  uniqueid = "CN",
  datsource = "datamart",
  data_dsn = NULL,
  states = NULL,
  eval_opts = eval_options(Cur = TRUE),
  savedata = FALSE,
  getassgn = TRUE,
  pop_plot_stratum_assgn = NULL,
  savedata_opts = NULL,
  dbconn = NULL,
  dbconnopen = FALSE,
  evalInfo = NULL,
  ...
)
}
\arguments{
\item{dat}{Data frame, comma-delimited file (*.csv), or shapefile (*.shp).
The strata value is merged to this table and returned as a data frame. See
details for necessary variables.}

\item{uniqueid}{String. The unique plot identifier of dat (e.g., 'CN').}

\item{datsource}{String. Source of data ('datamart', 'sqlite').}

\item{data_dsn}{String. If datsource='sqlite', the name of SQLite database
(*.sqlite).}

\item{states}{String or numeric vector. Name(s) (e.g., 'Arizona','New
Mexico') or code(s) (e.g., 4, 35) of states for strata if dat=NULL.}

\item{eval_opts}{List of evaluation options for 'FIA' or 'custom'
evaluations to determine the set of data returned. See help(eval_options)
for a list of options.}

\item{savedata}{Logical. If TRUE, writes output to outfolder.}

\item{getassgn}{Logical. If TRUE, extracts plot assignments from
pop_plot_stratum_assgn table in database.}

\item{pop_plot_stratum_assgn}{Data frame. The pop_plot_stratum_assgn for
state(s).}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options. Only used when savedata = TRUE.}

\item{dbconn}{Open database connection.}

\item{dbconnopen}{Logical. If TRUE, the dbconn connection is not closed.}

\item{evalInfo}{List. List object output from DBgetEvalid or DBgetXY}

\item{...}{For extendibility.
FIESTA functions.}
}
\value{
FIAstrata - a list of the following objects: \item{pltassgn}{ Data
frame. Plot-level strata/estimation unit assignment.  If dat is not NULL,
strata/estimation unit variables are appended to dat. } \item{pltassgnid}{
String. Name of unique identifier of plot in pltassgn. } \item{unitarea}{
Data frame. Total acres by estimation unit. } \item{unitvar}{ String. Name
of the estimation unit variable (ESTN_UNIT). } \item{areavar}{ String. Name
of the acre variable (ACRES). } \item{stratalut}{ Data frame. Strata look-up
table with summarized pixel counts (P1POINTCNT) by strata/estimation unit. }
\item{strvar}{ String. Name of the strata variable (STRATA). }
\item{strwtvar}{ String. Name of the strata weight variable (P1POINTCNT). }
\item{evalid}{ List. evalid by state. }

Outputs to outfolder (if savedata=TRUE): \tabular{ll}{ \tab - CSV file of
pltassgn (*'date'.csv).\cr \tab - CSV file of unitarea (*'date'.csv).\cr
\tab - CSV file of stratalut (*'date'.csv).\cr \tab - If collapsed, a CSV
file of original classes and new collapsed classes.\cr }
}
\description{
Gets strata information from FIA's Oracle database or FIA DataMart,
including: (1) strata and estimation unit assignment per plot; (2) total
area by estimation unit; (3) pixel counts and number plots by
strata/estimation unit. Include a data frame of plots, states, or evaluation
information.
}
\details{
The following variables must be present in dat: STATECD, UNITCD, INVYR, a
uniqueid (e.g. "PLT_CN"), and PLOT_STATUS_CD (if nonsampled plots in
dataset).

FIADB TABLES USED: \tabular{lll}{ \tab FS_FIADB.SURVEY \tab To get latest
inventory year.\cr \tab FS_FIADB.POP_EVAL \tab To get EVALID and EVALID
years.\cr \tab FS_FIADB.POP_ESTN_UNIT \tab To get total area by estimation
unit (AREATOT_EU-includes water).\cr \tab FS_FIADB.POP_STRATUM \tab To get
pixel counts by stratum and estimation unit.\cr \tab
FS_FIADB.POP_PLOT_STRATUM_ASSGN \tab To get estimation unit & stratum
assignment for each plot.\cr }

Area by estimation unit includes total area for all plots (Type="CURR").
}
\note{
Steps used in data extraction:

\enumerate{ \item Get EVALID and EVALID years by state - DBgetEvalid().
\item unitarea: get total area by estimation unit for EVALID
(POP_ESTN_UNIT).  \item stratalut: get pixel counts by estimation unit and
stratum for EVALID (POP_STRATUM).  \item pltassgn: get estimation unit and
stratum assignment for each plot for EVALID.  (POP_PLOT_STRATUM_ASSGN).
\item If dat is not NULL, merge pltassgn assignment to dat.  \item Merge
number of plots to stratalut \item Check for only 1 MEASYEAR or 1 INVYR and
number of plots by strata/estimation unit.  If less than minimumnum plots
per strata/estimation unit collapse using the following algorithm.  }

Strata collapsing: \cr If there are less than minplotnum (10) plots in the
smallest strata of the estimation unit, these plots are grouped with the
larger strata in the same estimation unit and defined as the highest strata
value. If, after grouping, there are still less than minplotnum, all of
these plots are combined with the corresponding strata of the estimation
unit above.  If there are no records above, then they are combined with the
estimation unit below.  The process repeats, grouping the strata to the
highest strata value if necessary.  All grouping is restrained within survey
units (UNITCD).

More than one evaluation: \cr If attributing a table of plots and there are
plots that have been visited more than once, all plots are assigned an
estimation unit and strata value, but the area and strata proportions are
from the most current evaluation for the dataset. The plots outside the most
current evaluation are attributes with values from the next most current
evaluation occurring in the database.
}
\examples{
\dontrun{
# Get strata for the most current evaluation of a state (ex. Wyoming)
WYstrat1 <- DBgetStrata(states = "Wyoming",
                        eval_opts = list(Cur = TRUE))
names(WYstrat1)

head(WYstrat1$pltassgn)
WYstrat1$unitarea
WYstrat1$unitvar
WYstrat1$areavar
WYstrat1$strvar
WYstrat1$evalid

# Get strata information for a specific set of plots
WYstrat4 <- DBgetStrata(dat = WYplt)
names(WYstrat4)

head(WYstrat4$pltassgn)
WYstrat4$unitarea
WYstrat4$evalid
}
}
\author{
Tracey S. Frescino
}
\keyword{data}
