% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datSumTree.R
\name{datSumTree}
\alias{datSumTree}
\title{Data - Aggregates numeric tree data to the plot or condition-level.}
\usage{
datSumTree(
  tree = NULL,
  seed = NULL,
  cond = NULL,
  plt = NULL,
  subp_cond = NULL,
  subplot = NULL,
  datsource = "obj",
  dbconn = NULL,
  dsn = NULL,
  bycond = FALSE,
  bysubp = FALSE,
  bydomainlst = NULL,
  tsumvarlst = NULL,
  tsumvarnmlst = NULL,
  seedlings = "N",
  woodland = "Y",
  tfilter = NULL,
  domclassify = NULL,
  tderive = NULL,
  getadjplot = FALSE,
  pltidsWITHqry = NULL,
  pltidsid = NULL,
  pcwhereqry = NULL,
  savedata = FALSE,
  tabIDs = tableIDs(),
  datSum_opts = datSum_options(),
  database_opts = NULL,
  savedata_opts = NULL
)
}
\arguments{
\item{tree}{Dataframe or comma-delimited file (*.csv). The tree-level table.}

\item{seed}{Dataframe or comma-delimited file (*.csv). The seedling table.}

\item{cond}{Dataframe or comma-delimited file (*.csv). Condition-level table
to join the aggregated tree data to, if bycond=TRUE. This table also may be
used for condition proportion or strata variables used if adjcond or
adjstrata = TRUE (See details below).  This table is optional.}

\item{plt}{Dataframe, comma-delimited file (*.csv), or shapefile (*.shp).
Plot-level table to join the aggregated tree data to, if bycond=FALSE. This
table is optional.}

\item{subp_cond}{Dataframe, comma-delimited file (*.csv), or shapefile (*.shp).
Subplot condition-level table to use to sum condition proportions, 
if bysubp=TRUE.}

\item{subplot}{Dataframe, comma-delimited file (*.csv), or shapefile (*.shp).
Subplot-level table to used to calculate adjustment factors, to remove 
nonsampled conditions (SUBP_STATUS_CD = 3). This table is optional. If 
included the aggregated tree data are joined to subplot before returning.}

\item{datsource}{String. Source of data ('obj', 'csv', 'sqlite', 'gdb').}

\item{dbconn}{Open database connection.}

\item{dsn}{String. If datsource='sqlite', the name of SQLite database
(*.sqlite).}

\item{bycond}{Logical. If TRUE, the data are aggregated to the condition
level (by: cuniqueid, condid). If FALSE, the data are aggregated to the plot
level (by: puniqueid). If bysubp = TRUE and bycond = TRUE, data are 
aggregated by subplotid, subpid, condid.}

\item{bysubp}{Logical. If TRUE, data are aggregated to the subplot level.}

\item{bydomainlst}{String (vector). Categorical domain variables for 
summing tree data by (e.g., SPCD). Variables must be in tree table or 
plt/cond table if tables are provided.}

\item{tsumvarlst}{String (vector). Tree-level variable(s) to aggregate
(e.g., "TPA_UNADJ", "BA"). Use "TPA_UNADJ" for summed tree
count.}

\item{tsumvarnmlst}{String (vector). Name of the tree-level variable(s) to
aggregate (e.g., "TPALIVE", "BALIVE"). This list must have the same number
of variables as tsumvarlst and be in respective order. If NULL, the default
names will be tsumvar_SUM (e.g., "TPA_UNADJ_SUM", "BA_SUM").}

\item{seedlings}{String. ('Y', 'N', 'only') If seedlings = 'Y', add
seedlings to summary ('TPA_UNADJ' %in% tsumvarlst). If seedlings = 'N',
do not add seedlings. If seedlings = 'only', only include seedlings.}

\item{woodland}{String. ('Y', 'N', 'only') If woodland = 'Y', include
woodland tree species where measured. If woodland = 'N', only include 
timber species. See FIESTA::ref_species$WOODLAND ='Y/N'. If woodland = 'only', 
only include woodland species. If NULL, use whatever is in table.}

\item{tfilter}{String. Filter to subset the tree data before aggregating
(e.g., "STATUSCD == 1"). This must be in R syntax. If tfilter=NULL, user is
prompted.  Use tfilter="NONE" if no filters.}

\item{domclassify}{List. List for classifying domain variables in bydomainlst
(e.g., DIA = c(10,20,30)).}

\item{tderive}{List. List of derivative from tree table to add to output data
(e.g., list(MEAN_DIA = 'AVG(DIA)', SDI = 'POWER(DIA / 10, 1.605)', 
QMD = 'SQRT(SUM(POWER(DIA,2) * 0.005454 * TPA_UNADJ) / (SUM(TPA_UNADJ)*0.005454))'))}

\item{getadjplot}{Logical. If TRUE, and adj='plot', adjfactors are 
calculated for nonsampled conditions at plot-level.}

\item{pltidsWITHqry}{SQL query. A query identifying plots to sum (e.g., 
'WITH pltids AS (SELECT cn AS PLT_CN FROM plot WHERE statecd=49 and INVYR=2018)')}

\item{pltidsid}{Sting. Name of unique identifier in pltidsWITHqry.}

\item{pcwhereqry}{String. Plot/Condition filter if plot and/or cond table is 
included.}

\item{savedata}{Logical. If TRUE, saves data to outfolder.}

\item{tabIDs}{List of unique IDs corresponding to the tables. See
See help(tableIDs) for a list of options.}

\item{datSum_opts}{List. Options for summarizing tree data, such as TPA,
rounding, and adjusting TPA. See help(datSum_options()) for a list of 
options.}

\item{database_opts}{List. Options for database, such as schema and 
password. See help(database_options()) for a list of options.}

\item{savedata_opts}{List. See help(savedata_options()) for a list}
}
\value{
A list of the following items: \item{treedat}{ Data frame. Plot or
condition-level table with aggregated tree attributes. } \item{sumvars}{
String vector. Name(s) of the output aggregated tree attributes. }

If savedata=TRUE\cr - treedat will be saved to the outfolder. \cr - a text
file of input parameters is saved to outfolder
('outfn'_parameters_'date'.txt).
}
\description{
Aggregates numeric tree-level data (e.g., VOLCFNET) to plot or condition,
including options for filtering tree data or extrapolating to plot aseedonlycre by
multiplying by TPA.
}
\details{
If variable = NULL, then it will prompt user for input.

Dependent external functions: datFilter Dependent internal functions:
addcommas, fileexistsnm, getadjfactor

For adjcond (bycond=FALSE): \cr If you want to summarize trees-per-acre
information aggregated to plot or condition level, you need to include a TPA
variable in tree table. \cr For tsumvars = GROWCFGS, GROWBFSL, GROWCFAL,
FGROWCFGS, FGROWBFSL, or FGROWCFAL, you must have TPAGROW_UNADJ \cr For
tsumvars = MORTCFGS, MORTBFSL, MORTCFAL, FMORTCFGS, FMORTBFSL, or FMORTCFAL,
you must have TPAMORT_UNADJ \cr For tsumvars = REMVCFGS, REMVBFSL, REMVCFAL,
FREMVCFGS, FREMVBFSL, or FREMVCFAL, you must have TPAREMV_UNADJ \cr

If you want to adjust plot-level or subplot-level information by condition 
proportions (adjplot), you need to include CONDID & CONDPROP_UNADJ in cond 
or tree table and COND_STATUS_CD. \cr
}
\note{
If a dat table is provided, the aggregated tree data will be merged to
table and NULL values will be output as 0.
}
\examples{
\donttest{
# Aggregate LIVE_CANOPY_CVR_PCT to plot
treesum <- datSumTree(tree = FIESTA::WYtree,
                      tsumvarlst = "TPA_UNADJ")$treedat

# Check results
treesum[treesum$PLT_CN == 40404737010690,]
FIESTA::WYtree[FIESTA::WYtree$PLT_CN == 40404737010690,]
}
}
\author{
Tracey S. Frescino
}
\keyword{data}
