% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMAT.R
\name{FMAT_load}
\alias{FMAT_load}
\title{(Down)Load BERT models (useless for GPU).}
\usage{
FMAT_load(models)
}
\arguments{
\item{models}{Model names at
\href{https://huggingface.co/models?pipeline_tag=fill-mask&library=transformers}{HuggingFace}.}
}
\value{
A named list of fill-mask pipelines obtained from the models.
The returned object \emph{cannot} be saved as any RData.
You will need to \emph{rerun} this function if you \emph{restart} the R session.
}
\description{
Load BERT models from local cache folder "\%USERPROFILE\%/.cache/huggingface".
Models that have not been downloaded can also
be automatically downloaded (but \emph{silently}).
For \href{https://psychbruce.github.io/FMAT/#guidance-for-gpu-acceleration}{GPU Acceleration},
please directly use \code{\link{FMAT_run}} instead.
}
\examples{
\dontrun{
model.names = c("bert-base-uncased", "bert-base-cased")
models = FMAT_load(model.names)  # load models from cache
}

}
\seealso{
\code{\link{BERT_download}}

\code{\link{FMAT_query}}

\code{\link{FMAT_query_bind}}

\code{\link{FMAT_run}}
}
