% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometryfns.R
\name{SpatialPolygonsDataFrame_to_df}
\alias{SpatialPolygonsDataFrame_to_df}
\title{SpatialPolygonsDataFrame to df}
\usage{
SpatialPolygonsDataFrame_to_df(sp_polys, vars = names(sp_polys))
}
\arguments{
\item{sp_polys}{object of class \code{SpatialPolygonsDataFrame}}

\item{vars}{variables to put into data frame (by default all of them)}
}
\description{
Convert \code{SpatialPolygonsDataFrame} object to data frame.
}
\details{
This function is mainly used for plotting \code{SpatialPolygonsDataFrame} objects with \code{ggplot} rather than \code{spplot}. The coordinates of each polygon are extracted and concatenated into one long data frame. The attributes of each polygon are then attached to this data frame as variables that vary by polygon \code{id} (the rownames of the object).
}
\examples{
library(sp)
library(ggplot2)
opts_FRK$set("parallel",0L)
df <- data.frame(id = c(rep(1,4),rep(2,4)),
                 x = c(0,1,0,0,2,3,2,2),
                 y=c(0,0,1,0,0,1,1,0))
pols <- df_to_SpatialPolygons(df,"id",c("x","y"),CRS())
polsdf <- SpatialPolygonsDataFrame(pols,data.frame(p = c(1,2),row.names=row.names(pols)))
df2 <- SpatialPolygonsDataFrame_to_df(polsdf)
\dontrun{ggplot(df2,aes(x=x,y=y,group=id)) + geom_polygon()}
}
