% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/plottingfns.R
\docType{methods}
\name{show_basis}
\alias{show_basis}
\alias{show_basis,Basis-method}
\alias{show_basis,TensorP_Basis-method}
\title{Show basis functions}
\usage{
show_basis(basis, ...)

\S4method{show_basis}{Basis}(basis, g = ggplot() + theme_bw() + xlab("")
  + ylab(""))

\S4method{show_basis}{TensorP_Basis}(basis, g = ggplot())
}
\arguments{
\item{basis}{object of class \code{Basis}}

\item{...}{not in use}

\item{g}{object of class \code{gg} (a \code{ggplot} object) over which to overlay the basis functions (optional)}
}
\description{
Generic plotting function for visualising the basis functions.
}
\details{
The function \code{show_basis} adapts its behaviour to the manifold being used. With \code{real_line}, the 1D basis functions are plotted with colour distinguishing between the different resolutions. With \code{plane}, only local basis functions are supported (at present). Each basis function is shown as a circle with diameter equal to the \code{scale} parameter of the function. Linetype distinguishes the resolution. With \code{sphere}, the centres of the basis functions are shown as circles, with larger sizes corresponding to coarser resolutions. Space-time basis functions of subclass \code{TensorP_Basis} are visualised by showing the spatial basis functions and the temporal basis functions in two separate plots.
}
\examples{
library(ggplot2)
library(sp)
data(meuse)
coordinates(meuse) = ~x+y # change into an sp object
G <- auto_basis(manifold = plane(),data=meuse,nres = 2,regular=2,prune=0.1,type = "bisquare")
\dontrun{show_basis(G,ggplot()) + geom_point(data=data.frame(meuse),aes(x,y))}
}
\seealso{
\code{\link{auto_basis}} for automatically constructing basis functions.
}
