% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSAUtils.R
\name{peek}
\alias{peek}
\title{Peek into (show a subset of) a data frame or matrix.}
\usage{
peek(x, n = 20L, which = NULL, addrownums = TRUE)
}
\arguments{
\item{x}{A data frame or matrix.}

\item{n}{A single numeric that indicates the number of rows to display.}

\item{which}{A numeric or string vector that contains the column numbers or names to display. Defaults to showing all columns.}

\item{addrownums}{If there are no row names for the MATRIX, then create them from the row numbers.}
}
\value{
A matrix or data.frame with n rows.
}
\description{
Shows the first, last, and approximately evenly spaced rows from a data frame or matrix.
}
\note{
If \code{n} is larger than the number of rows in \code{x} then all of \code{x} is displayed.
}
\examples{
peek(CutthroatAL)
peek(CutthroatAL,n=6)
peek(CutthroatAL,n=6,which=c("id","y1998","y1999","y2000"))

## Make a matrix for demonstration purposes only
mCutthroatAL <- as.matrix(CutthroatAL)
peek(mCutthroatAL)
peek(mCutthroatAL,n=6)
peek(mCutthroatAL,n=6,addrownums=FALSE)
peek(mCutthroatAL,n=6,which=2:4)

## Make a tibble type from dplyr ... note how peek() is not limited by
## the tibble restriction on number of rows to show (but head() is).
\dontrun{
  if (require(dplyr)) {
    CutthroatAL2 <- as_tibble(CutthroatAL)
    class(CutthroatAL2)
    peek(CutthroatAL2,n=6)
    head(CutthroatAL2,n=15)
  }
}

}
\seealso{
\code{headtail}
}
\author{
Derek H. Ogle, \email{DerekOgle51@gmail.com}

A. Powell Wheeler, \email{powell.wheeler@gmail.com}
}
\keyword{manip}
