context("lencat() VALIDATE")
source("EXS_lencat.R")

test_that("lencat() results",{
  ## Simple examples (same width as that created)
  tmp <- lencat(~len1,data=df2,w=1)
  expect_is(tmp,"data.frame")
  expect_equal(colnames(tmp),c(colnames(df2),"LCat"))
  expect_is(tmp$LCat,"numeric")
  tmp <- lencat(~len0.1,data=df2,w=0.1)
  expect_is(tmp,"data.frame")
  expect_equal(colnames(tmp),c(colnames(df2),"LCat"))
  expect_is(tmp$LCat,"numeric")
  tmp <- lencat(~len0.01,data=df2,w=0.01)
  expect_is(tmp,"data.frame")
  expect_equal(colnames(tmp),c(colnames(df2),"LCat"))
  expect_is(tmp$LCat,"numeric")
  tmp <- lencat(~len10,data=df2,w=10)
  expect_is(tmp,"data.frame")
  expect_equal(colnames(tmp),c(colnames(df2),"LCat"))
  expect_is(tmp$LCat,"numeric")
  ## Does it handle 1-column data.frame
  tmp <- lencat(data.frame(df2$len1),w=1)
  expect_is(tmp,"numeric")
  ## Different widths (don't control startcat)
  tmp <- lencat(~len1,data=df2,w=2)
  expect_is(tmp,"data.frame")
  expect_equal(colnames(tmp),c(colnames(df2),"LCat"))
  expect_is(tmp$LCat,"numeric")
  tmp <- lencat(~len0.1,data=df2,w=0.2)
  expect_is(tmp,"data.frame")
  expect_equal(colnames(tmp),c(colnames(df2),"LCat"))
  expect_is(tmp$LCat,"numeric")
  tmp <- lencat(~len10,data=df2,w=20)
  expect_is(tmp,"data.frame")
  expect_equal(colnames(tmp),c(colnames(df2),"LCat"))
  expect_is(tmp$LCat,"numeric")
  ## Different widths (control startcat)
  tmp <- lencat(~len1,data=df2,w=2,startcat=1)
  expect_is(tmp$LCat,"numeric")
  expect_is(tmp,"data.frame")
  expect_equal(colnames(tmp),c(colnames(df2),"LCat"))
  tmp <- lencat(~len0.1,data=df2,w=0.2,startcat=0.1)
  expect_is(tmp$LCat,"numeric")
  expect_is(tmp,"data.frame")
  expect_equal(colnames(tmp),c(colnames(df2),"LCat"))
  tmp <- lencat(~len10,data=df2,w=20,startcat=10)
  expect_is(tmp$LCat,"numeric")
  ## Using breaks
  tmp <- lencat(~len1,data=df2,breaks=c(1,2,4))
  expect_is(tmp,"data.frame")
  expect_equal(colnames(tmp),c(colnames(df2),"LCat"))
  expect_is(tmp$LCat,"numeric")
  tmp <- lencat(~len0.1,data=df2,breaks=c(1,2,4)/10)
  expect_is(tmp,"data.frame")
  expect_equal(colnames(tmp),c(colnames(df2),"LCat"))
  expect_is(tmp$LCat,"numeric")
  ## using named breaks
  # but don't use names
  tmp <- lencat(~len1,data=df2,breaks=c(one=1,two=2,four=4))
  expect_is(tmp,"data.frame")
  expect_equal(colnames(tmp),c(colnames(df2),"LCat"))
  expect_is(tmp$LCat,"numeric")
  # but do use names
  tmp <- lencat(~len1,data=df2,breaks=c(one=1,two=2,four=4),use.names=TRUE)
  expect_is(tmp,"data.frame")
  expect_equal(colnames(tmp),c(colnames(df2),"LCat"))
  expect_is(tmp$LCat,"factor")
  # use names but don't return as a factor
  tmp <- lencat(~len1,data=df2,breaks=c(one=1,two=2,four=4),use.names=TRUE,as.fact=FALSE)
  expect_is(tmp,"data.frame")
  expect_equal(colnames(tmp),c(colnames(df2),"LCat"))
  expect_is(tmp$LCat,"character")
})