\name{carrierprobgeno}
\alias{carrierprobgeno}
\title{
Mutation carrier probabilities for individuals with missing genotypes conditional on observed genotypes}
\description{
This function computes carrier probabilities for individuals with missing genotypes conditional on observed mutation in the family members. The alternative approach, \code{\link{carrierprobpheno}}, uses both observed mutation and phenotype information among family members.
}
\usage{
carrierprobgeno(data, method="data", mode="dominant", q=0.02)
}
\arguments{
  \item{data}{
Family data that includes missing genotypes generated by the function \code{simfam}.
}
 \item{method}{
Choice of methods to calculate the carrier probability. Possible choices are \code{"data"} for empirical calculation of the carrier probabilities based on the observed carriers' statuses in the entire sample, specific to generation and proband's mutation status or \code{"mendelian"} using  Mendelian transmission probabilies with a fixed allele frequency and mutation status observed in the family. 
 Default is \code{"data"}.
 If \code{method="mendelian"}, specify both \code{mode} of the inheritance and the allele frequency \code{q}. 
 
}
 \item{mode}{
Choice of modes of inheritance. Possible choices are \code{"dominant"} for dominant model or \code{"recessive"} for recessive model. Default is \code{"dominant"}.
}

 \item{q}{
Frequency of the disease-causing allele. The value should be between 0 and 1. If \code{NULL}, the estimated allele frequency from data will be used. Default value  is \code{0.02}.
}
}
\details{
Carrier probabilies are calcuated conditional on the observed mutation status in the family following Mendelian transmission (\code{method="mendelian"}) or calculated empirically (\code{method="data"}) based on the observed mutation status in the entire family data set by estimating the proportion of mutation carriers in each generation. 

The carrier probabilies are required for the EM algorithm to fit the pentrance model to the data with missing genotypes.
}
\value{
Returns a data frame with a vector of carrier probabilities called \code{carrp} added after the last column of the family data.
}
\author{
Yun-Hee Choi
}
\seealso{
\code{\link{simfam}, \link{penmodelEM}, \link{plot.simfam}}
}
\examples{

# Simulate family data that includes 30\% of individuals with missing mutation 
# status (mrate=0.3).

fam <- simfam(N.fam=100, design="pop", variation="frailty", 
       base.dist="Weibull", frailty.dist="gamma", depend=1, allelefreq=0.02, 
       base.parms=c(0.01,3), vbeta=c(-1.13, 2.35), mrate=0.3)
    
# Carrier probabilities of individuals with missing genetic information 
# based on Mendelian transmission.

newfam <- carrierprobgeno(fam, method="mendelian", mode="dominant", q=NULL)

# pedigree plot for family 1 displaying carrier probabilities

plot.simfam(newfam, famid=1)
}
\keyword{Carrier probability}
