% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.jmcs.R
\name{anova}
\alias{anova}
\alias{anova.jmcs}
\title{Anova Method for Fitted Joint Models}
\usage{
\method{anova}{jmcs}(object, object2, digits = 4, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{jmcs}, nested in \code{object2}.}

\item{object2}{an object inheriting from class \code{jmcs}.}

\item{digits}{the number of significant digits to use when printing. Default is 4.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A table to summarize the likelihood ratio test.
}
\description{
Performs a likelihood ratio test between two nested joint models.
}
\examples{
\donttest{
# Fit a joint model
fit <- jmcs(ydata = ydata, cdata = cdata, 
            long.formula = response ~ time + x1, 
            surv.formula = Surv(surv, failure_type) ~ x1 + x2, 
            random =  ~ time| ID)

fit2 <- jmcs(ydata = ydata, cdata = cdata, 
            long.formula = response ~ time + gender + x1 + race, 
            surv.formula = Surv(surv, failure_type) ~ x1 + gender + x2 + race, 
            random =  ~ time| ID)      

anova(fit, fit2)   
}
             
}
\seealso{
\code{\link{jmcs}}
}
\author{
Shanpeng Li \email{lishanpeng0913@ucla.edu}
}
