% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UnitTestHelperFunctions.R
\name{.getDbLooCovariateData}
\alias{.getDbLooCovariateData}
\title{Get covariate information from the database}
\usage{
.getDbLooCovariateData(
  connection,
  oracleTempSchema = NULL,
  cdmDatabaseSchema,
  cohortTable = "#cohort_person",
  cohortIds = c(-1),
  cdmVersion = "5",
  rowIdField = "subject_id",
  covariateSettings,
  aggregated = FALSE,
  minCharacterizationMean = 0
)
}
\arguments{
\item{connection}{A connection to the server containing the schema as created using the
\code{connect} function in the \code{DatabaseConnector} package.
Either the \code{connection} or \code{connectionDetails} argument
should be specified.}

\item{oracleTempSchema}{A schema where temp tables can be created in Oracle.}

\item{cdmDatabaseSchema}{The name of the database schema that contains the OMOP CDM instance.
Requires read permissions to this database. On SQL Server, this should
specify both the database and the schema, so for example
'cdm_instance.dbo'.}

\item{cohortTable}{Name of the (temp) table holding the cohort for which we want to
construct covariates}

\item{cohortIds}{For which cohort ID(s) should covariates be constructed? If set to -1,
covariates will be constructed for all cohorts in the specified cohort
table.}

\item{cdmVersion}{Define the OMOP CDM version used: currently supported is "5".}

\item{rowIdField}{The name of the field in the cohort table that is to be used as the
row_id field in the output table. This can be especially usefull if
there is more than one period per person.}

\item{covariateSettings}{Either an object of type \code{covariateSettings} as created using one
of the createCovariate functions, or a list of such objects.}

\item{aggregated}{Should aggregate statistics be computed instead of covariates per
cohort entry?}

\item{minCharacterizationMean}{The minimum mean value for binary characterization output. Values below this will be cut off from output. This
will help reduce the file size of the characterization output, but will remove information
on covariates that have very low values. The default is 0.}
}
\value{
Returns an object of type \code{covariateData}, containing information on the covariates.
}
\description{
Get covariate information from the database
}
