% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04.FF_both.R
\name{get.matrix.adjacency.both}
\alias{get.matrix.adjacency.both}
\title{Create a firm-firm (FF) matrix}
\usage{
get.matrix.adjacency.both(
  ...,
  ties = 3,
  id_as_firm_name = NULL,
  Matrix = NULL,
  self_ties = FALSE,
  combining = "sum"
)
}
\arguments{
\item{...}{Either multiple objects of class \code{firm} or a list of such objects}

\item{ties}{Type of ties to create. Defaults to \code{2}; for other possible values, see details.}

\item{id_as_firm_name}{Whether to use the ticker as the firm's name. Defaults to \code{TRUE} if all firms' id is neither \code{NULL} nor \code{NA}.}

\item{Matrix}{Whether to use the \href{https://cran.r-project.org/package=Matrix}{\code{Matrix} package}. Defaults to \code{TRUE} when any matrix in the pipeline contains more than 10,000 cells and the package is installed.}

\item{self_ties}{Whether to allow self-ties (a 'loop' in graph theory). Defaults to \code{FALSE}.}

\item{combining}{How to combine the FF matrix for managers and that for owners (see Details);}
}
\value{
A matrix object of class \code{financial_matrix}(possibly using the \href{https://cran.r-project.org/package=Matrix}{\code{Matrix} package})
}
\description{
Function to create a firm-firm (FF) matrix based on both common ownership and board interlocks
}
\details{
The possible values of \code{ties} and their effect relative to the value of \code{who} are:

  \code{binary} or \code{1} for binary ties: \eqn{1} if there is at least one common manager or owner, \eqn{0} otherwise.

  \code{naive}, or \code{2} for 'naively' valued ties indicating the number of common managers and owners.

  \code{share} or \code{3} (the default) for 'normalised' tie values. The actual value depends on \code{combining}:
  \itemize{
   \item for \code{sum} (the default), the sum of the share of \eqn{i}'s owners who are also amongst \eqn{j}'s owners and the share of \eqn{i}'s managers who are also amongst \eqn{j}'s managers (normalised to 2);
   \item for \code{mean} or \code{avg}, the mean of the share of \eqn{i}'s owners who are also amongst \eqn{j}'s owners and the share of \eqn{i}'s managers who are also amongst \eqn{j}'s managers (normalised to 1);
   \item for \code{max}, the maximum between the share of \eqn{i}'s owners who are also amongst \eqn{j}'s owners and the share of \eqn{i}'s managers who are also amongst \eqn{j}'s managers (normalised to 1);
   \item for \code{min}, the minimum between the share of \eqn{i}'s owners who are also amongst \eqn{j}'s owners and the share of \eqn{i}'s managers who are also amongst \eqn{j}'s managers (normalised to 1);
  }
}
\seealso{
\link{FF} \link{FF.binary.both} \link{FF.naive.both} \link{FF.norm.both}
}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
\keyword{internal}
