% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02.FOandFM.R
\name{get.matrix.twomode}
\alias{get.matrix.twomode}
\title{Function to create a firm-owner (FO) or firm-manager (FM) matrix}
\usage{
get.matrix.twomode(..., who, ties = 3, id_as_firm_name = NULL, Matrix = NULL)
}
\arguments{
\item{...}{Either multiple objects of class \code{firm} or a list of such objects}

\item{who}{Whether to extract the 'managers' or the 'owners' (minimum unambiguous string)}

\item{ties}{Type of ties to create. Defaults to \code{3}; for other possible values, see details.}

\item{id_as_firm_name}{Whether to use the ticker as the firm's name. Defaults to \code{TRUE} if all firms' id is neither \code{NULL} nor \code{NA}.}

\item{Matrix}{Whether to use the \href{https://cran.r-project.org/package=Matrix}{\code{Matrix} package}. Defaults to \code{TRUE} when there are more than 10,000 combinations and the package is installed.}
}
\value{
A matrix object of class \code{financial_matrix} (possibly using the \href{https://cran.r-project.org/package=Matrix}{\code{Matrix} package}) in which:
\describe{
 \item{the rows}{Represent firms;}
 \item{the columns}{Represent managers/owners (physical and legal persons).}
}
}
\description{
The possible values of \code{ties} are:
\itemize{
  \item \code{binary} or \code{1} for binary ties;
  \item \code{weighted}, \code{valued}, or \code{2} to weight the tie between company \eqn{i} and the person \eqn{j} as the value of \eqn{j}'s share of \eqn{i}'s capital;
  \item \code{share} or \code{3} (the default) to weight the tie between company \eqn{i} and the person \eqn{j} as the share of \eqn{i}'s capital owned by \eqn{j}.
}
}
\seealso{
\link{FM} \link{FO.binary} \link{FO.naive} \link{FO.norm}
}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
\keyword{internal}
