% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MainFunctions.R
\name{EpsilonExtrapolation}
\alias{EpsilonExtrapolation}
\title{EpsilonExtrapolation
This function takes a matrix with previous iterates and extrapolates the limit of the sequence.}
\usage{
EpsilonExtrapolation(Iterates, Method = c("VEA", "SEA"))
}
\arguments{
\item{Iterates}{A matrix representing different iterates with one iterate per column. Can be pieced together from Inputs and Outputs matrices of
the FixedPoint function using the PutTogetherIteratesWithoutJumps function}

\item{Method}{Method for epsilon extrapolation. Should be either "VEA" for the vector extrapolation algorithm or "SEA" for the scalar epsilon algorithm.}
}
\value{
A vector with the extrapolated vector.
}
\description{
EpsilonExtrapolation
This function takes a matrix with previous iterates and extrapolates the limit of the sequence.
}
\examples{
FPFunction = function(x){c(0.5*sqrt(abs(x[1] + x[2])), 1.5*x[1] + 0.5*x[2])}
A = FixedPoint( Function = FPFunction, Inputs = c(0.3,900), MaxIter = 6, Method = "Simple")
Iterates = PutTogetherIteratesWithoutJumps(A$Inputs, A$Outputs)
EpsilonExtrapolation(Iterates, "VEA")
B = FixedPoint( function(x){cos(x)}, Inputs = 1, MaxIter = 5, Method = "Simple")
Iterates = PutTogetherIteratesWithoutJumps(B$Inputs, B$Outputs)
EpsilonExtrapolation(Iterates, "SEA")
}
