// Generated by rstantools.  Do not edit by hand.

/*
    FlexReg is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    FlexReg is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with FlexReg.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_BetaBin_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 16, column 1 to column 16)",
                                                      " (in 'string', line 17, column 1 to column 29)",
                                                      " (in 'string', line 20, column 1 to column 32)",
                                                      " (in 'string', line 21, column 1 to column 19)",
                                                      " (in 'string', line 23, column 1 to column 23)",
                                                      " (in 'string', line 32, column 2 to column 27)",
                                                      " (in 'string', line 31, column 6 to line 32, column 27)",
                                                      " (in 'string', line 30, column 2 to column 29)",
                                                      " (in 'string', line 29, column 6 to line 32, column 27)",
                                                      " (in 'string', line 28, column 2 to column 21)",
                                                      " (in 'string', line 27, column 6 to line 32, column 27)",
                                                      " (in 'string', line 26, column 2 to column 27)",
                                                      " (in 'string', line 25, column 1 to line 32, column 27)",
                                                      " (in 'string', line 51, column 1 to column 19)",
                                                      " (in 'string', line 53, column 2 to column 215)",
                                                      " (in 'string', line 52, column 14 to line 54, column 2)",
                                                      " (in 'string', line 52, column 1 to line 54, column 2)",
                                                      " (in 'string', line 37, column 1 to column 44)",
                                                      " (in 'string', line 42, column 3 to column 40)",
                                                      " (in 'string', line 41, column 7 to line 42, column 40)",
                                                      " (in 'string', line 40, column 3 to column 40)",
                                                      " (in 'string', line 39, column 2 to line 42, column 40)",
                                                      " (in 'string', line 38, column 16 to line 43, column 2)",
                                                      " (in 'string', line 38, column 1 to line 43, column 2)",
                                                      " (in 'string', line 47, column 1 to column 155)",
                                                      " (in 'string', line 46, column 14 to line 48, column 2)",
                                                      " (in 'string', line 46, column 1 to line 48, column 2)",
                                                      " (in 'string', line 2, column 1 to column 16)",
                                                      " (in 'string', line 3, column 7 to column 8)",
                                                      " (in 'string', line 3, column 1 to column 16)",
                                                      " (in 'string', line 4, column 7 to column 8)",
                                                      " (in 'string', line 4, column 1 to column 16)",
                                                      " (in 'string', line 5, column 1 to column 16)",
                                                      " (in 'string', line 6, column 8 to column 9)",
                                                      " (in 'string', line 6, column 10 to column 11)",
                                                      " (in 'string', line 6, column 1 to column 15)",
                                                      " (in 'string', line 8, column 1 to column 27)",
                                                      " (in 'string', line 9, column 1 to column 30)",
                                                      " (in 'string', line 10, column 1 to column 31)",
                                                      " (in 'string', line 12, column 1 to column 29)",
                                                      " (in 'string', line 13, column 1 to column 29)",
                                                      " (in 'string', line 16, column 8 to column 9)",
                                                      " (in 'string', line 20, column 25 to column 26)",
                                                      " (in 'string', line 51, column 8 to column 9)"};
#include <stan_meta_header.hpp>
class model_BetaBin final : public model_base_crtp<model_BetaBin> {
private:
  int N;
  std::vector<int> n;
  std::vector<int> y;
  int K;
  Eigen::Matrix<double, -1, -1> X;
  int link_code_mu;
  int link_prior_beta;
  double hyperprior_beta;
  double hyper_theta_a;
  double hyper_theta_b;
 
public:
  ~model_BetaBin() { }
  
  inline std::string model_name() const final { return "model_BetaBin"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_BetaBin(stan::io::var_context& context__,
                unsigned int random_seed__ = 0,
                std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_BetaBin_namespace::model_BetaBin";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 28;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 28;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 28;
      current_statement__ = 28;
      check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 29;
      validate_non_negative_index("n", "N", N);
      current_statement__ = 30;
      context__.validate_dims("data initialization","n","int",
          context__.to_vec(N));
      n = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 30;
      assign(n, nil_index_list(), context__.vals_i("n"),
        "assigning variable n");
      current_statement__ = 31;
      validate_non_negative_index("y", "N", N);
      current_statement__ = 32;
      context__.validate_dims("data initialization","y","int",
          context__.to_vec(N));
      y = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 32;
      assign(y, nil_index_list(), context__.vals_i("y"),
        "assigning variable y");
      current_statement__ = 33;
      context__.validate_dims("data initialization","K","int",
          context__.to_vec());
      K = std::numeric_limits<int>::min();
      
      current_statement__ = 33;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 33;
      current_statement__ = 33;
      check_greater_or_equal(function__, "K", K, 1);
      current_statement__ = 34;
      validate_non_negative_index("X", "N", N);
      current_statement__ = 35;
      validate_non_negative_index("X", "K", K);
      current_statement__ = 36;
      context__.validate_dims("data initialization","X","double",
          context__.to_vec(N, K));
      X = Eigen::Matrix<double, -1, -1>(N, K);
      stan::math::fill(X, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 36;
        assign(X_flat__, nil_index_list(), context__.vals_r("X"),
          "assigning variable X_flat__");
        current_statement__ = 36;
        pos__ = 1;
        current_statement__ = 36;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 36;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 36;
            assign(X,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_flat__[(pos__ - 1)], "assigning variable X");
            current_statement__ = 36;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 37;
      context__.validate_dims("data initialization","link_code_mu","int",
          context__.to_vec());
      link_code_mu = std::numeric_limits<int>::min();
      
      current_statement__ = 37;
      link_code_mu = context__.vals_i("link_code_mu")[(1 - 1)];
      current_statement__ = 37;
      current_statement__ = 37;
      check_greater_or_equal(function__, "link_code_mu", link_code_mu, 1);
      current_statement__ = 38;
      context__.validate_dims("data initialization","link_prior_beta","int",
          context__.to_vec());
      link_prior_beta = std::numeric_limits<int>::min();
      
      current_statement__ = 38;
      link_prior_beta = context__.vals_i("link_prior_beta")[(1 - 1)];
      current_statement__ = 38;
      current_statement__ = 38;
      check_greater_or_equal(function__, "link_prior_beta", link_prior_beta,
                             1);
      current_statement__ = 39;
      context__.validate_dims("data initialization","hyperprior_beta",
          "double",context__.to_vec());
      hyperprior_beta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 39;
      hyperprior_beta = context__.vals_r("hyperprior_beta")[(1 - 1)];
      current_statement__ = 39;
      current_statement__ = 39;
      check_greater_or_equal(function__, "hyperprior_beta", hyperprior_beta,
                             0);
      current_statement__ = 40;
      context__.validate_dims("data initialization","hyper_theta_a","double",
          context__.to_vec());
      hyper_theta_a = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 40;
      hyper_theta_a = context__.vals_r("hyper_theta_a")[(1 - 1)];
      current_statement__ = 40;
      current_statement__ = 40;
      check_greater_or_equal(function__, "hyper_theta_a", hyper_theta_a, 0);
      current_statement__ = 41;
      context__.validate_dims("data initialization","hyper_theta_b","double",
          context__.to_vec());
      hyper_theta_b = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 41;
      hyper_theta_b = context__.vals_r("hyper_theta_b")[(1 - 1)];
      current_statement__ = 41;
      current_statement__ = 41;
      check_greater_or_equal(function__, "hyper_theta_b", hyper_theta_b, 0);
      current_statement__ = 42;
      validate_non_negative_index("beta", "K", K);
      current_statement__ = 43;
      validate_non_negative_index("mu", "N", N);
      current_statement__ = 44;
      validate_non_negative_index("log_lik", "N", N);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += K;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_BetaBin_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(beta, DUMMY_VAR__);
      
      current_statement__ = 1;
      beta = in__.vector(K);
      local_scalar_t__ theta;
      theta = DUMMY_VAR__;
      
      current_statement__ = 2;
      theta = in__.scalar();
      current_statement__ = 2;
      if (jacobian__) {
        current_statement__ = 2;
        theta = stan::math::lub_constrain(theta, 0, 1, lp__);
      } else {
        current_statement__ = 2;
        theta = stan::math::lub_constrain(theta, 0, 1);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> mu;
      mu = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(mu, DUMMY_VAR__);
      
      local_scalar_t__ phi;
      phi = DUMMY_VAR__;
      
      current_statement__ = 5;
      phi = ((1 - theta) / theta);
      current_statement__ = 13;
      if (logical_eq(link_code_mu, 1)) {
        current_statement__ = 12;
        assign(mu, nil_index_list(), inv_logit(multiply(X, beta)),
          "assigning variable mu");
      } else {
        current_statement__ = 11;
        if (logical_eq(link_code_mu, 2)) {
          current_statement__ = 10;
          assign(mu, nil_index_list(), Phi(multiply(X, beta)),
            "assigning variable mu");
        } else {
          current_statement__ = 9;
          if (logical_eq(link_code_mu, 3)) {
            current_statement__ = 8;
            assign(mu, nil_index_list(), inv_cloglog(multiply(X, beta)),
              "assigning variable mu");
          } else {
            current_statement__ = 7;
            if (logical_eq(link_code_mu, 4)) {
              current_statement__ = 6;
              assign(mu, nil_index_list(),
                stan::math::exp(minus(stan::math::exp(multiply(X, beta)))),
                "assigning variable mu");
            } 
          }
        }
      }
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 3;
        current_statement__ = 3;
        check_greater_or_equal(function__, "mu[sym1__]", mu[(sym1__ - 1)], 0);
      }
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 3;
        current_statement__ = 3;
        check_less_or_equal(function__, "mu[sym1__]", mu[(sym1__ - 1)], 1);}
      current_statement__ = 4;
      current_statement__ = 4;
      check_greater_or_equal(function__, "phi", phi, 0);
      {
        current_statement__ = 18;
        lp_accum__.add(
          beta_lpdf<propto__>(theta, hyper_theta_a, hyper_theta_b));
        current_statement__ = 24;
        for (int l = 1; l <= K; ++l) {
          current_statement__ = 22;
          if (logical_eq(link_prior_beta, 1)) {
            current_statement__ = 21;
            lp_accum__.add(
              normal_lpdf<propto__>(beta[(l - 1)], 0, hyperprior_beta));
          } else {
            current_statement__ = 20;
            if (logical_eq(link_prior_beta, 2)) {
              current_statement__ = 19;
              lp_accum__.add(
                cauchy_lpdf<propto__>(beta[(l - 1)], 0, hyperprior_beta));
            } 
          }}
        current_statement__ = 27;
        for (int i = 1; i <= N; ++i) {
          current_statement__ = 25;
          lp_accum__.add(
            (((((stan::math::lgamma(phi) -
                  stan::math::lgamma((phi * mu[(i - 1)]))) -
                 stan::math::lgamma((phi * (1 - mu[(i - 1)])))) +
                stan::math::lgamma(((phi * mu[(i - 1)]) + y[(i - 1)]))) +
               stan::math::lgamma(
                 (((phi * (1 - mu[(i - 1)])) + n[(i - 1)]) - y[(i - 1)]))) -
              stan::math::lgamma((phi + n[(i - 1)]))));}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_BetaBin_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      beta = in__.vector(K);
      double theta;
      theta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      theta = in__.scalar();
      current_statement__ = 2;
      theta = stan::math::lub_constrain(theta, 0, 1);
      Eigen::Matrix<double, -1, 1> mu;
      mu = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      double phi;
      phi = std::numeric_limits<double>::quiet_NaN();
      
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      vars__.emplace_back(theta);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 5;
      phi = ((1 - theta) / theta);
      current_statement__ = 13;
      if (logical_eq(link_code_mu, 1)) {
        current_statement__ = 12;
        assign(mu, nil_index_list(), inv_logit(multiply(X, beta)),
          "assigning variable mu");
      } else {
        current_statement__ = 11;
        if (logical_eq(link_code_mu, 2)) {
          current_statement__ = 10;
          assign(mu, nil_index_list(), Phi(multiply(X, beta)),
            "assigning variable mu");
        } else {
          current_statement__ = 9;
          if (logical_eq(link_code_mu, 3)) {
            current_statement__ = 8;
            assign(mu, nil_index_list(), inv_cloglog(multiply(X, beta)),
              "assigning variable mu");
          } else {
            current_statement__ = 7;
            if (logical_eq(link_code_mu, 4)) {
              current_statement__ = 6;
              assign(mu, nil_index_list(),
                stan::math::exp(minus(stan::math::exp(multiply(X, beta)))),
                "assigning variable mu");
            } 
          }
        }
      }
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 3;
        current_statement__ = 3;
        check_greater_or_equal(function__, "mu[sym1__]", mu[(sym1__ - 1)], 0);
      }
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 3;
        current_statement__ = 3;
        check_less_or_equal(function__, "mu[sym1__]", mu[(sym1__ - 1)], 1);}
      current_statement__ = 4;
      current_statement__ = 4;
      check_greater_or_equal(function__, "phi", phi, 0);
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(mu[(sym1__ - 1)]);}
        vars__.emplace_back(phi);
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      Eigen::Matrix<double, -1, 1> log_lik;
      log_lik = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(log_lik, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 17;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 15;
        assign(log_lik, cons_list(index_uni(i), nil_index_list()),
          ((((((((stan::math::lgamma((n[(i - 1)] + 1)) -
                   stan::math::lgamma((y[(i - 1)] + 1))) -
                  stan::math::lgamma(((n[(i - 1)] - y[(i - 1)]) + 1))) +
                 stan::math::lgamma(phi)) -
                stan::math::lgamma((phi * mu[(i - 1)]))) -
               stan::math::lgamma((phi * (1 - mu[(i - 1)])))) +
              stan::math::lgamma(((phi * mu[(i - 1)]) + y[(i - 1)]))) +
             stan::math::lgamma(
               (((phi * (1 - mu[(i - 1)])) + n[(i - 1)]) - y[(i - 1)]))) -
            stan::math::lgamma((phi + n[(i - 1)]))),
          "assigning variable log_lik");}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(log_lik[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 1;
        assign(beta_flat__, nil_index_list(), context__.vals_r("beta"),
          "assigning variable beta_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 1;
          assign(beta, cons_list(index_uni(sym1__), nil_index_list()),
            beta_flat__[(pos__ - 1)], "assigning variable beta");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      double theta;
      theta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      theta = context__.vals_r("theta")[(1 - 1)];
      double theta_free__;
      theta_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      theta_free__ = stan::math::lub_free(theta, 0, 1);
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      vars__.emplace_back(theta_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("beta");
    names__.emplace_back("theta");
    names__.emplace_back("mu");
    names__.emplace_back("phi");
    names__.emplace_back("log_lik");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "theta");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "phi");
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "theta");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "phi");
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_BetaBin_namespace::model_BetaBin;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_BetaBin_namespace::profiles__;
}
#endif
#endif
