% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_oneparam.r
\name{bf_oneparam}
\alias{bf_oneparam}
\title{One parameter recursive digital filter}
\usage{
bf_oneparam(discharge, k)
}
\arguments{
\item{discharge}{Numeric vector of daily flow data}

\item{k}{Numeric value for the recession constant (dimensionless).}
}
\value{
Returns a numeric vector of the estimated baseflow.
}
\description{
This function estimates baseflow.
}
\examples{
data(cania.sub.ts)
res <- bf_oneparam(cania.sub.ts$Flow, k=0.9)
plot(cania.sub.ts$Date, cania.sub.ts$Flow, xlab="", ylab="Q (m3/s)", type="l")
points(cania.sub.ts$Date, res, type="l", col="blue")
}
\author{
Paul H. Whitfield
}
\references{
Eckhardt, K. 2005. How to construct recursive digital filters
  for baseflow separation methods. Journal of Hydrology 352: 168-173.
}

