% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FoRDM.R
\name{build_objectives_satisficing}
\alias{build_objectives_satisficing}
\title{Build Objectives Data Frame for Satisficing Analysis}
\usage{
build_objectives_satisficing(
  names,
  time_aggregation = rep("mean", length(names)),
  discount_rate = rep(0, length(names)),
  threshold,
  direction = rep("above", length(names))
)
}
\arguments{
\item{names}{Names of objectives as the column names in the provided data.}

\item{time_aggregation}{Time aggregation across objectives: 'mean', 'sum', 'min' or 'max'.}

\item{discount_rate}{Discount rates for each objective (e.g., 0.02 means 2\% per time step), applied during time aggregation.}

\item{threshold}{Numeric value(s) defining the satisficing level for each objective.}

\item{direction}{'above' if values should meet or exceed the threshold, 'below' if they should be lower.}
}
\value{
A data frame specifying objectives name, time aggregation method, discount rate, threshold and direction for use in satisficing FoRDM analysis.
}
\description{
Specify information for satisficing-based FoRDM analysis. For each objective, define its name, time aggregation method (mean, sum, min or max), discount rate, threshold and direction.
}
