% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topdown.R
\name{tetd}
\alias{tetd}
\title{Temporal top-down reconciliation}
\usage{
tetd(base, agg_order, weights, tew = "sum", normalize = TRUE)
}
\arguments{
\item{base}{A (\eqn{hm \times 1}) numeric vector containing the temporal
aggregated base forecasts of order \eqn{m}; \eqn{m} is the max aggregation
order, and \eqn{h} is the forecast horizon for the lowest frequency
time series.}

\item{agg_order}{Highest available sampling frequency per seasonal cycle (max. order
of temporal aggregation, \eqn{m}), or a vector representing a subset of \eqn{p} factors
of \eqn{m}.}

\item{weights}{A (\eqn{hm \times 1}) numeric vector containing the proportions for the
high-frequency time series; \eqn{m} is the max aggregation order, and \eqn{h} is the
forecast horizon for the lowest frequency time series.}

\item{tew}{A string specifying the type of temporal aggregation. Options include:
"\code{sum}" (simple summation, \emph{default}), "\code{avg}" (average),
"\code{first}" (first value of the period), and "\code{last}"
(last value of the period).}

\item{normalize}{If \code{TRUE} (\emph{default}), the \code{weights} will sum to 1.}
}
\value{
A (\eqn{h(k^\ast+m) \times 1}) numeric vector of temporal reconciled forecasts.
}
\description{
Top-down forecast reconciliation for a univariate time series, where the forecast
of the most aggregated temporal level is disaggregated according to a proportional
scheme (weights). Besides fulfilling any aggregation constraint, the
top-down reconciled forecasts should respect two main properties:
\itemize{
\item the top-level value remains unchanged;
\item all the bottom time series reconciled forecasts are non-negative.
}
}
\examples{
set.seed(123)
# (2 x 1) top base forecasts vector (simulated), forecast horizon = 2
topf <- rnorm(2, 10)
# Same weights for different forecast horizons
fix_weights <- runif(4)
reco <- tetd(base = topf, agg_order = 4, weights = fix_weights)

# Different weights for different forecast horizons
h_weights <- runif(4*2)
recoh <- tetd(base = topf, agg_order = 4, weights = h_weights)

}
\seealso{
Top-down reconciliation: 
\code{\link{cstd}()},
\code{\link{cttd}()}

Temporal framework: 
\code{\link{teboot}()},
\code{\link{tebu}()},
\code{\link{tecov}()},
\code{\link{telcc}()},
\code{\link{temo}()},
\code{\link{terec}()},
\code{\link{tetools}()}
}
\concept{Framework: temporal}
\concept{Reco: top-down}
