% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IncidenceMatrix

%Two new commands to help with formatting
\newcommand{\methodtable}{\bold{\cr #1 \cr} \tabular{lcl}}
\newcommand{\methoditem}{\emph{#1} \tab-\tab #2\cr}
\newcommand{\methodname}{\subsection{#1}}
\docType{class}
\name{IncidenceMatrix}
\alias{IncidenceMatrix}
\title{IncidenceMatrix}
\description{A class for storing a matrix and relevant metaData.}
\seealso{
Inherits from : \code{\link{AbstractIncidenceMatrix}}

}
\examples{
data = IncidenceMatrix$new(matrix(1:9,3,3))
data$mat
data$nrow
data$ncol
data$colData = list(1:3,letters[1:3])
data$colData
data$addColumns(2)
data$colData
data$mat
data$diff(1)
data$mat
data$lag(1)
data$mat
data$head(1,1)
data$mat
data$tail(2,2)
data$mat
data$mutate(data=3)
data$mat
data = IncidenceMatrix$new(matrix(1:9,3,3))
data$scale(function(x)\{x^2\},mutate=FALSE)$mat
data$mat
data$subset(rows=1,cols=2)
data$mat
}
\section{Fields}{
\describe{
\item{cellData}{A list of metadata associated with the cells of the data.}
\item{cnames}{The names of columns in the data.}
\item{colData}{A list of metadata associated with the columns of the data.}
\item{frame}{A data.frame representation of the IncidenceMatrix.  The frame contains all rows/columns as rows of the data frame, and the rows, columns, values and all metadata types as columns.  This is similar to the melt function.}
\item{mat}{This is the matrix.  For extensibility, it cannot be written to directly and must be modified through methods.}
\item{metaData}{Any data not part of the main data structure.}
\item{ncol}{The number of columns in the data.}
\item{nrow}{The number of rows in the data}
\item{rnames}{The names of rows in the data.}
\item{rowData}{A list of metadata associated with the columns of the data.}
}}
\section{Methods}{
\methodname{addColumns(columns)}{
This function adds empty columns to the right side of the data.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{columns}{The number of columns to add.}
}}}}
\methodname{addRows(rows)}{
This function adds empty rows to the data.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{rows}{The number of rows to add.}
}}}}
\methodname{as_sts(pop_name = 'pop',freq_name = 'freq',start_name = 'start',epoch_name = 'epoch',map_name = 'map',neighbourhood_name = 'neighbourhood')}{
Convert this object to an sts object with as much information as possible
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{pop_name}{string with the name of rowData to use as the population of the sts object.}
\methoditem{freq_name}{string with the name of metaData to use as the frequency of the sts object.}
\methoditem{start_name}{string with the name of metaData to use as the start of the sts object.}
\methoditem{epoch_name}{string with the name of the colData to use as the epoch of the sts object.}
\methoditem{map_name}{string with the name of the rowData to use as the map of the sts object.}
\methoditem{neighbourhood_name}{string with the name of the rowData to use as the neighbourhood of th ests object.}
}}}}
\methodname{debug(string)}{
A function for debugging the methods of this class.  It calls the \link{browser} command.  In order for methods to opt into to debugging, they need to implement the following code at the beginning: if(<method_name> \%in\% private$.debug)\{browser()\}.  This method exists, because the debugger is not always intuitive when it comes to debugging R6 methods.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of methods to debug as a character vector}
}}}}
\methodname{diff(lag = 1,mutate=TRUE)}{
This function replaces the matrix value at column i with the difference. between the values at columns i and (i-lag).
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{lag}{ How far back to diff.  Defaults to 1.}
\methoditem{mutate}{Whether to change the original instance, or create a new one.  If FALSE, the instance performing the method will be left unchanged, and a modified copy will be returned.  If true, then the instance will modify itself and return nothing.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{head(k,direction=2,mutate=TRUE)}{
Select the last \code{k} slices of the data in dimension \code{direction}.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{k}{The number of slices to keep.}
\methoditem{direction}{The dimension to take a subset of. 1 for row, 2 for column.}
\methoditem{mutate}{Whether to change the original instance, or create a new one.  If FALSE, the instance performing the method will be left unchanged, and a modified copy will be returned.  If true, then the instance will modify itself and return nothing.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{initialize(data=matrix(),metaData=list(),rowData=list(),colData=list(),cellData = list())}{
Create a new \code{IncidenceMatrix} object from its components.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{data}{Either a matrix, or an object of class MatrixData.  If data is a matrix, it will form the mat field.  If data is a MatrixData, then the new object will inherit all of its fields.}
}}}}
\methodname{lag(indices,mutate=TRUE,na.rm=FALSE)}{
This function replaces the current matrix with a new matrix with one  column for every column, and a row for every row/index combination.  The column corresponding to the row and index will have the value of the  original matrix in the same row, but index columns previous.  This  shift will introduce NAs where it passes off the end of the matrix.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{indices}{A sequence of lags to use as part of the data.  Note that unless this list contains 0, the data will all be shifted back by at least one year.}
\methoditem{mutate}{Whether to change the original instance, or create a new one.  If FALSE, the instance performing the method will be left unchanged, and a modified copy will be returned.  If true, then the instance will modify itself and return nothing.}
\methoditem{na.rm}{Whether to remove NA values generated by walking off the edge of the matrix.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{lead(indices,mutate=TRUE,na.rm=FALSE)}{
This function replaces the current matrix with a new matrix with one column for every column, and a row for every row/index combination.  The column corresponding to the row and index will have the value of the original matrix in the same row, but index columns ahead.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{indices}{A sequence of leads to use as part of the data.  Note that unless this list contains \\code{0}, the data will all be shifted foreward by one year.}
\methoditem{mutate}{Whether to modify this object, or create and return a modified object.}
\methoditem{na.rm}{Whether to remove the NA columns that result where the lead goes off the edge of self$simulations.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{mutate(rows,cols,data)}{
This function is a way to modify the data as though it were a matrix.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{rows}{Which rows to modify.  These can be numeric or names.}
\methoditem{cols}{Which cols to modify.  These can be numeric or names.}
\methoditem{data}{The data to change the chosen values to.  It needs to be the right shape.}
}}}}
\methodname{scale(f,mutate=TRUE)}{
This function rescales each element of our object according to f
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{f}{a function which takes in a number and outputs a rescaled version of that number}
\methoditem{mutate}{Whether to change the original instance, or create a new one.  If FALSE, the instance performing the method will be left unchanged, and a modified copy will be returned.  If true, then the instance will modify itself and return nothing.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{subset(rows,cols,mutate=TRUE)}{
Select the data corresponding to the rows \code{rows} and the columns \code{columns}.  \code{rows} and \code{columns} can be either numeric or named indices.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{rows}{An row index or list of row indices which can be either numeric or named.}
\methoditem{cols}{An column index or list of column indices which can be either numeric or named.}
\methoditem{mutate}{Whether to change the original instance, or create a new one.  If FALSE, the instance performing the method will be left unchanged, and a modified copy will be returned.  If true, then the instance will modify itself and return nothing.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{tail(k,direction=2,mutate=TRUE)}{
Select the last \code{k} slices of the data in dimension \code{direction}.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{k}{The number of slices to keep.}
\methoditem{direction}{The dimension to take a subset of. 1 for row, 2 for column.}
\methoditem{mutate}{Whether to change the original instance, or create a new one.  If FALSE, the instance performing the method will be left unchanged, and a modified copy will be returned.  If true, then the instance will modify itself and return nothing.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{undebug(string)}{
A function for ceasing to debug methods.  Normally a method will call the \link{browser} command every time it is run.  This command will stop it from doing so.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of the methods to stop debugging.}
}}}}
}
