#' @name HouseholdsB
#' @aliases HouseholdsB
#' @docType data
#' @title Database of household expenses for frame B
#' 
#' @description This dataset contains some variables regarding household expenses for a sample of 135 households selected from a list of mobile phones (let say, frame B) in a particular city in a specific month.
#' @usage HouseholdsB
#' @details The sample, of size \eqn{n_B = 135}, has been drawn from a population of \eqn{N_B = 1191} households with mobile phone. \eqn{N_{ab} = 601} of these households have, also, landline phone. 
#'  On the other hand, frame totals for auxiliary variables in this frame are \eqn{X_{Metres2}^B = 176553} and \eqn{X_{Size}^B = 3529}
#' @format
#' \describe{
#'    \item{Domain}{A string indicating the domain each household belongs to. Possible values are "b" if household belongs to domain b or "ba" if household belongs to overlap domain.}
#'    \item{Feeding}{Feeding expenses (in euros) at the househould}
#'    \item{Clothing}{Clothing expenses (in euros) at the household}
#'    \item{Leisure}{Leisure expenses (in euros) at the household}
#'    \item{Income}{Household income (in euros). Values for this variable are only available for households included in frame A.}
#'    \item{Taxes}{Household municipal taxes (in euros) paid. Values for this variable are only available for households included in frame A.}
#'    \item{Metres2}{Square meters of the house. Values for this variable are only available for households included in frame B.}
#'    \item{Size}{Household size. Values for this variable are only available for households included in frame B.}
#'    \item{ProbA}{First order inclusion probability in frame A.}
#'    \item{ProbB}{First order inclusion probability in frame B.}
#' }
#' @examples
#' data(HouseholdsB)
#' attach(HouseholdsB)
#' #Let perform a brief descriptive analysis for the three main variables
#' param <- data.frame(Feeding, Clothing, Leisure)
#' summary (param)
#' hist (Feeding)
#' hist (Clothing)
#' hist (Leisure)
#' @keywords datasets
NULL