% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/VarHT.R
\name{VarHT}
\alias{VarHT}
\title{Variance estimator of Horvitz - Thompson estimator}
\usage{
VarHT(y, pikl)
}
\arguments{
\item{y}{A numeric vector of size n containing information about variable of interest}

\item{pikl}{A square numeric matrix of dimension n containing first and second order inclusion probabilities for units included in \code{y}}
}
\value{
A numeric value representing variance estimator of Horvitz - Thompson estimator for population total for considered values
}
\description{
Computes the variance estimator of Horvitz - Thompson estimator of population total
}
\details{
Variance estimator of Horvitz - Thompson estimator of population total is given by
 \deqn{\hat{Var}(\hat{Y}_{HT}) = \sum_{k \in s}\frac{y_k^2}{\pi_k^2}(1 - \pi_k) + \sum_{k \in s}\sum_{l \in s, l \neq k} \frac{y_k y_l}{\pi_k \pi_l} \frac{\pi_{kl} - \pi_k \pi_l}{\pi_{kl}}}
}
\examples{
##########   Example 1   ##########
U <- c(13, 18, 20, 14, 9)
#A simple random sample of size 2 without replacement is drawn from population
s <- sample(U, 2)
#Horvitz - Thompson estimator of population total is calculated.
ps <- c(0.4, 0.4)
HT(s, ps)
#Now, we calculate variance estimator of the Horvitz - Thompson estimator.
Ps <- matrix(c(0.4,0.1, 0.1,0.4), 2 ,2)
VarHT(s, Ps)

##########   Example 2   ##########
data(DatA)
attach(DatA)
data(PiklA)

#Let calculate Horvitz - Thompson estimator for total of variable Clothing in Frame A.
HT(Clo, ProbA)
#And now, let compute the variance of the previous estimator
VarHT(Clo, PiklA)
}
\references{
Horvitz, D. G. and Thompson, D. J. (1952)
 \emph{A generalization of sampling without replacement from a finite universe.}
 Journal of the American Statistical Association, 47, 663 - 685

Sarndal, C. E., Swensson, B. and Wretman, J. (1992)
 \emph{Model Assisted Survey Sampling}. Springer-Verlag. New York.
}
\seealso{
\code{\link{HT}} \code{\link{CovHT}}
}

