% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function-compare.R
\docType{methods}
\name{compareResults}
\alias{compareResults}
\alias{compareResults,matrix-method}
\alias{compareResults,FuzzyData,character-method}
\title{Function to rank results}
\usage{
compareResults(data)

\S4method{compareResults}{matrix}(data)
}
\arguments{
\item{data}{A matrix with one column. Usually an output of function \code{calculateAHP.}}
}
\value{
A \code{"matrix"} of numeric value that indicates ranking of each row, with the highest value ranked as 1.
}
\description{
This function ranks data from the highest value to the lowest. Essentially it does
\code{(nrow(data)+1) - rank(data, na.last ="keep", ties.method= "max")}.
}
