require("testthat")

test_that("inverting side/alpha-cut generators numerically", {
   
   x <- seq(0,1,by=0.001)
   
   fi <- approxInvert(function(x) x)
   expect_that(fi(x), equals(x))
   
   fi <- approxInvert(function(x) x^2)
   expect_that(fi(x), equals(sqrt(x)))
   
   fi <- approxInvert(function(x) x^3)
   expect_that(fi(x), equals(x^(1/3)))
   
   fi <- approxInvert(function(x) pbeta(x, 1, 2))
   expect_that(fi(x), equals(qbeta(x, 1, 2)))
   
   fi <- approxInvert(function(x) 1-pbeta(x, 1, 2))
   expect_that(fi(x), equals(qbeta(1-x, 1, 2)))
   
#    fi <- approxInvert(function(x) pbeta(x, 0.3, 1))
#    expect_that(fi(x), equals(qbeta(x, 0.3, 1)))
})

