% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-as.FuzzyNumber.R
\docType{methods}
\name{as.FuzzyNumber}
\alias{as.FuzzyNumber}
\alias{as.FuzzyNumber,numeric-method}
\alias{as.FuzzyNumber,FuzzyNumber-method}
\title{Converts an Object to a Fuzzy Number}
\usage{
\S4method{as.FuzzyNumber}{numeric}(object)

\S4method{as.FuzzyNumber}{FuzzyNumber}(object)
}
\arguments{
\item{object}{a fuzzy number or a single numeric value (crisp number)
or vector of length two (interval)}
}
\value{
Returns an bject of class \code{\linkS4class{FuzzyNumber}}.
}
\description{
Please note that applying this function on a \linkS4class{FuzzyNumber}
child class causes information loss, as it drops all additional slots
defined in the child classes.
\code{\linkS4class{FuzzyNumber}} is the base class for all FNs.
Note that some functions for TFNs or PLFNs
work much faster and are more precise. This function shouldn't be
used in normal computations.
}
\seealso{
Other FuzzyNumber-method: \code{\link{Arithmetic}},
  \code{\link{FuzzyNumber-class}},
  \code{\link{FuzzyNumber}}, \code{\link{alphaInterval}},
  \code{\link{alphacut}}, \code{\link{ambiguity}},
  \code{\link{as.PiecewiseLinearFuzzyNumber}},
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{as.character}}, \code{\link{core}},
  \code{\link{distance}}, \code{\link{evaluate}},
  \code{\link{expectedInterval}},
  \code{\link{expectedValue}},
  \code{\link{integrateAlpha}},
  \code{\link{piecewiseLinearApproximation}},
  \code{\link{plot}}, \code{\link{show}},
  \code{\link{supp}},
  \code{\link{trapezoidalApproximation}},
  \code{\link{value}}, \code{\link{weightedExpectedValue}},
  \code{\link{width}}

Other conversion: \code{\link{as.PiecewiseLinearFuzzyNumber}},
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{as.character}}
}
\concept{FuzzyNumber-method}
\concept{conversion}
