% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_order.R
\name{fs_order}
\alias{fs_order}
\title{Fuzzy monetary poverty estimation}
\usage{
fs_order(data, vec_order)
}
\arguments{
\item{data}{a data-set of n columns with the considered items}

\item{vec_order}{a vector length n with TRUE or FALSE. True if the order of the variable is to be inverted, False otherwise}
}
\value{
A dataset with the same item of data  with inverted order for those with vec_order==TRUE
}
\description{
Detect and invert deprivation items for FS
}
\examples{
#Create data
data=data.frame("X"=rep(c(1,2,3,4),20), "Y"=rep(c(7,8,9,1),20))
#Crete vec_order
vec_order=c(TRUE,FALSE)
##
fs_order(data=data, vec_order)


}
