% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_var.R
\name{fs_var}
\alias{fs_var}
\title{Fuzzy supplementary poverty estimation.}
\usage{
fs_var(
  data,
  weight = NULL,
  ID = NULL,
  dimensions,
  HCR,
  breakdown = NULL,
  alpha,
  rho = NULL,
  type = "bootstrap",
  R = 500,
  M = NULL,
  stratum,
  psu,
  f = 0.01,
  verbose = TRUE
)
}
\arguments{
\item{data}{A matrix or data frame of items.}

\item{weight}{A numeric vector of sampling weights. if NULL simple random sampling weights will be used}

\item{ID}{A numeric or character vector of IDs. if NULL (the default) it is set as the row sequence.}

\item{dimensions}{A numeric vector (of length  \code{ncol(data)}) of assignments of items in data to dimensions.}

\item{HCR}{The head count ratio.}

\item{breakdown}{A factor of sub-domains to calculate estimates for (using the same alpha). If numeric will be coerced to a factor.}

\item{alpha}{The value of the exponent in equation $E(mu)^(alpha-1) = HCR$. If NULL it is calculated so that it equates the expectation of the membership function to HCR.}

\item{rho}{The critical value to be used for calculation of weights in the kendall correlation matrix.}

\item{type}{The variance estimation method chosen. One between \code{bootstrap} (default) or \code{jackknife}.}

\item{R}{The number of bootstrap replicates. Default is 500.}

\item{M}{The size of bootstrap samples. Default is \code{nrow(data)}.}

\item{stratum}{The vector identifying the stratum (if 'jackknife' is chosen as variance estimation technique).}

\item{psu}{The vector identifying the psu (if 'jackknife' is chosen as variance estimation technique).}

\item{f}{The finite population correction fraction (if 'jackknife' is chosen as variance estimation technique).}

\item{verbose}{Logical. whether to print the proceeding of the variance estimation procedure.}
}
\value{
An object of class FuzzySupplementary containing the estimated variance.
}
\description{
Fuzzy supplementary poverty estimation.
}
\examples{
dimensions = c(1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5)
fs_var(data = eusilc[,4:23], weight = eusilc$DB090, ID = NULL,
dimensions = dimensions, breakdown = NULL, HCR = .16, alpha = 2,
rho = NULL, type = 'bootstrap', M = NULL, R = 2, verbose = TRUE)
}
