% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp_fit.R
\name{gp_fit}
\alias{gp_fit}
\title{Fit a Gaussian Process Model}
\usage{
gp_fit(
  design,
  response,
  options = list(formula = ~1, kernel = "matern5_2", optimizer = "gen", nuggetUse =
    TRUE)
)
}
\arguments{
\item{design}{A matrix of \code{n} rows and \code{d} columns.}

\item{response}{A column vector of length \code{n}.}

\item{options}{A list specifying the type of GP model to fit (see \code{\link[DiceKriging]{km}}).}
}
\value{
A list of properties from class \code{km} (see \code{\link[DiceKriging]{km-class}}).
}
\description{
This function fits a Gaussian process (GP) model to a set of possible designs and their corresponding design criterion evaluations. 
This GP will then be used to optimize the design criterion using an expected improvement criterion.
}
\examples{
x  <- matrix(seq(-1,1,0.3),ncol=1)
y  <- x^2 
gp <- gp_fit(x,
             y,
             options=list(formula=~1, 
             kernel = "matern5_2", 
             optimizer = "gen", 
             nuggetUse = FALSE))
gp_plot(gp$km.model,seq(-1.5,1.5,0.1))
  
}
