% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GBJ_objective.R
\name{GBJ_objective}
\alias{GBJ_objective}
\title{GBJ_objective.R}
\usage{
GBJ_objective(t_vec, d, k_vec = NULL, pairwise_cors, offset = 0)
}
\arguments{
\item{t_vec}{A scalar or vector of threshold points (magnitudes of test statistics)
to calculate the objective at.}

\item{d}{The total number of test statistics in the set.}

\item{k_vec}{If t_vec is not a vector all of the test statistics, let us know which ordered
objective functions we are calculating (can be a vector with the same length as t).}

\item{pairwise_cors}{A vector of all d(d-1)/2 pairwise correlations between the test
statistics, where d is total number of test statistics in the set.}

\item{offset}{Used if we want to subtract the observed gbj value for uniroot.}
}
\value{
The GBJ objective at t (for given d, kkk, pairwise_cors) minus the offset
}
\description{
Calculates the GBJ objective function at given threshold points.  Used both to calculate the
observed GBJ statistic and also to find the boundary points for p-value calculation (through uniroot).
Mostly for internal use.
}
\examples{
GBJ_objective(t_vec=1:5, d=5, k_vec=NULL, pairwise_cors=rep(0.2,10), offset=0)
}
\keyword{internal}
