% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov_functions.R
\name{vcov_local_factor}
\alias{vcov_local_factor}
\title{Get the covariance estimates for the local factors}
\usage{
vcov_local_factor(object, i, t)
}
\arguments{
\item{object}{An S3 object of class 'multi_result' created by multilevel().}

\item{i}{An integer indicating the \eqn{i}-th block.}

\item{t}{An integer specifying the time point.}
}
\value{
An \eqn{r_{i} \times r_{i}} covariance matrix.
}
\description{
This function generates the covariance estimates
for the local factors in block \eqn{i} at time \eqn{t}.
}
\examples{
panel <- UKhouse # load the data
est_multi <- multilevel(panel, ic = "BIC3", standarise = TRUE, r_max = 5,
                           depvar_header = "dlPrice", i_header = "Region",
                           j_header = "LPA_Type", t_header = "Date")
vcov_local_factor_11 <- vcov_local_factor(est_multi, i = 1, t = 1)
}
