% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelcomp.R, R/extract.modelcomp.R,
%   R/summary.GDINA.R
\name{modelcomp}
\alias{modelcomp}
\alias{extract.modelcomp}
\alias{summary.modelcomp}
\title{Item-level model comparison using Wald test}
\usage{
modelcomp(GDINA.obj, item = "all", DS = FALSE, SE.type = 2,
  models = c("DINA", "DINO", "ACDM", "LLM", "RRUM"), varcov = NULL)

\method{extract}{modelcomp}(object, what = c("wald", "wald.p", "df", "DS",
  "models"), digits = 4, ...)

\method{summary}{modelcomp}(object, ...)
}
\arguments{
\item{GDINA.obj}{An estimated model object of class \code{GDINA}}

\item{item}{a vector of items to specify which items the Wald test is applied to}

\item{DS}{whether dissimilarity index should be calculated? \code{FALSE} is the default.}

\item{SE.type}{the type of standard error estimates.}

\item{models}{a vector specifying which reduced CDMs are possible reduced CDMs for each
item. The default is "DINA","DINO","ACDM","LLM",and "RRUM".}

\item{varcov}{Optional; user specified variance-covariance matrix. If supplied, it must
be a list of length \eqn{J}, giving the variance covariance matrix of item success probability for each item.
The default is \code{NULL}, in which case, the estimated variance-covariance matrix from the GDINA function
is used.}

\item{object}{object of class \code{modelcomp} for various S3 methods}

\item{what}{argument for S3 method \code{extract} indicating what to extract;
It can be \code{"wald"} for wald statistics, \code{"wald.p"} for associated p-values,
\code{"df"} for degrees of freedom,
and \code{"DS"} for dissimilarity between G-DINA and other CDMs.}

\item{digits}{How many decimal places in each number? The default is 4.}

\item{...}{additional arguments}
}
\value{
an object of class \code{modelcomp}. Elements that can be
extracted using \code{extract} method include
\describe{
\item{wald}{wald statistics}
\item{wald.p}{p-values associated with the wald statistics}
\item{DS}{dissimilarity between G-DINA and other CDMs}
}
}
\description{
This function evaluates whether the saturated G-DINA model can be replaced by reduced
CDMs without significant loss in model data fit for each item. See de la Torre and Lee (2013),
and Ma, Iaconangelo and de la Torre (2016) for details. This function also calculates the dissimilarity
between the reduced models and the G-DINA model, which can be viewed as a measure of effect size (Ma, Iaconangelo & de la Torre, 2016).
}
\section{Methods (by generic)}{
\itemize{
\item \code{extract}: extract various elements from \code{modelcomp} objects

\item \code{summary}: print summary information
}}

\examples{
\dontrun{
dat <- sim10GDINA$simdat
Q <- sim10GDINA$simQ
# --- GDINA model ---#
mod1 <- GDINA(dat = dat, Q = Q, model = "GDINA")
mod1
wmod1 <- modelcomp(mod1)
wmod1
# wald statistics
extract(wmod1,"wald")
#p values
extract(wmod1,"wald.p")
wmod1r <- modelcomp(mod1,DS=TRUE)
#dissimilarity index
extract(wmod1r,"DS")
wmod2 <- modelcomp(mod1,models = c("DINA","DINO"))
wmod2
wmod3 <- modelcomp(mod1,item=c(8,9,10),DS=FALSE)
wmod3
}
}
\references{
de la Torre, J., & Lee, Y. S. (2013). Evaluating the wald test for item-level comparison of
saturated and reduced models in cognitive diagnosis. \emph{Journal of Educational Measurement, 50}, 355-373.

Ma, W., Iaconangelo, C., & de la Torre, J. (2016). Model similarity, model selection and attribute classification.
\emph{Applied Psychological Measurement, 40}, 200-217.
}
\seealso{
\code{\link{GDINA}}, \code{\link{autoGDINA}}
}
\author{
{Wenchao Ma, Rutgers University, \email{wenchao.ma@rutgers.edu} \cr Jimmy de la Torre, The University of Hong Kong}

Wenchao Ma & Jimmy de la Torre
}
