\name{g.plot}
\alias{g.plot}
\title{
function to generate a plot for quality check purposes
}
\description{
Function takes meta-data as generated by \link{g.getmeta} and \link{g.impute}
to create a visual representation of imputed time periods
}
\usage{
g.plot(IMP, M, I, durplot)
}
\arguments{
  \item{IMP}{
  output from \link{g.impute}
}
  \item{M}{
  output from \link{g.getmeta}
}
  \item{I}{
  output from \link{g.inspectfile}
}
  \item{durplot}{
number of days to plot
}
}
\value{
function only produces a plot, no values
}
\examples{
\dontrun{
  #inspect file:
  I = g.inspectfile(datafile)
  
  #autocalibration:
  C = g.calibrate(datafile) 
  
  #get meta-data:
  M = g.getmeta(datafile)
}
data(data.getmeta)
data(data.inspectfile)

#impute meta-data:
IMP = g.impute(M = data.getmeta, I = data.inspectfile, strategy = 1,
hrs.del.start = 0, hrs.del.end = 0, maxdur = 0)

#plot data
g.plot(IMP, M = data.getmeta, I = data.inspectfile, durplot=4)
}

\author{
  Vincent T van Hees <vincentvanhees@gmail.com>
}