% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glcm_textures.R
\name{glcm_textures}
\alias{glcm_textures}
\title{Calculates GLCM texture metrics of a Raster Layer}
\usage{
glcm_textures(
  r,
  w = c(3, 3),
  n_levels,
  shift = list(c(1, 0), c(1, 1), c(0, 1), c(-1, 1)),
  metrics = c("glcm_contrast", "glcm_dissimilarity", "glcm_homogeneity", "glcm_ASM",
    "glcm_entropy", "glcm_mean", "glcm_variance", "glcm_correlation"),
  quantization,
  min_val = NULL,
  max_val = NULL,
  na.rm = FALSE,
  filename = NULL,
  overwrite = FALSE,
  wopt = list()
)
}
\arguments{
\item{r}{A single layer SpatRaster or RasterLayer. If already quantized set quantization to "none". The valid range of values for a quantized raster is from 0 to n_levels-1 (e.g. a raster with 32 grey levels would have a valid range of 0-31).}

\item{w}{A vector of length 2 specifying the dimensions of the rectangular window to use where the first number is the number of rows and the second number is the number of columns. Window size must be an odd number.}

\item{n_levels}{Number of grey levels used in the quantization (Typically set to 16 or 32).}

\item{shift}{A vector of length 2, or a list of vectors each of length 2 specifying the relationship between neighboring pixel to the reference pixel. The first number represents the shift in the x direction and the second number represents the shift in the y direction, where up and right are positive. For example c(1,0) is the pixel directly to the right. The GLCM is made symmetrical by counting each pair twice, once "forwards" and once "backwards" by interchanging reference and neighbor pixels. Therefore a shift directly to the right c(1,0) is equivalent to a shift directly to the left c(-1,0). To average over "all directions" you can use shift=list(c(1,0), c(1,1), c(0,1), c(-1,1)), which is the default.}

\item{metrics}{A vector of glcm texture metrics to return. Valid entries include "glcm_contrast", "glcm_dissimilarity", "glcm_homogeneity", "glcm_ASM", "glcm_entropy", "glcm_mean", "glcm_variance", "glcm_correlation".}

\item{quantization}{quantization method (either "equal range", "equal prob", or "none"). "equal range" quantization will create bins that cover a range of equal size. "equal prob" performs equal probability quantization and will use quantiles to create bins with approximately equal number of samples. "none" means the layer has already been quantized.}

\item{min_val}{minimum value for equal range quantization (if not supplied, the minimum value of the raster is used)}

\item{max_val}{maximum value for equal range quantization (if not supplied, the maximum value of the raster is used)}

\item{na.rm}{a logical value indicating whether NA values should be stripped before the computation proceeds (default=FALSE)}

\item{filename}{character Output filename. Can be a single filename, or as many filenames as there are layers to write a file for each layer}

\item{overwrite}{logical. If TRUE, filename is overwritten (default is FALSE).}

\item{wopt}{list with named options for writing files as in writeRaster}
}
\value{
a SpatRaster or Raster* Object
}
\description{
Calculates GLCM texture metrics of a RasterLayer over a sliding rectangular window
}
\examples{
r<- rast(volcano, extent= ext(2667400, 2667400 + ncol(volcano)*10,
6478700, 6478700 + nrow(volcano)*10), crs = "EPSG:27200")
txt <- glcm_textures(r, w = c(3,5), n_levels = 16,
quantization = "equal prob", shift = list(c(1, 0), c(1, 1),
c(0, 1), c(-1, 1)))
plot(txt)
}
\references{
Hall-Beyer, M., 2017. GLCM Texture: A Tutorial v. 3.0. University of Calgary, Alberta, Canada.

Haralick, R.M., Shanmugam, K., Dinstein, I., 1973. Textural features for image classification. IEEE Transactions on Systems, Man, and Cybernetics 610–621. https://doi.org/10.1109/TSMC.1973.4309314
}
