% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GLMcat}
\alias{GLMcat}
\title{Family of models for categorical responses (reference, adjacent, sequential and cumulative ratio)}
\usage{
GLMcat(
  formula,
  data,
  ratio = "reference",
  distribution = "logistic",
  proportional = NA_character_,
  categories_order = NA_character_,
  ref_category = NA_character_,
  freedom_degrees = NaN,
  threshold = "standard",
  beta_init = NA_real_
)
}
\arguments{
\item{formula}{a symbolic description of the model to be fit. An expression of the form y ~ predictors is interpreted as a specification that the response y is modelled by a linear predictor specified symbolically by model.}

\item{data}{a dataframe object in R, with the dependent variable as factor.}

\item{ratio}{a string indicating the F distribution, options are: reference, adjacent, cumulative and sequential. Default value is reference.}

\item{distribution}{a string indicating the F distribution, options are: logistic, normal, cauchit, student (any df), gompertz, gumbel.}

\item{proportional}{a character vector indicating the name of the variables with a proportional effect.}

\item{categories_order}{a character vector indicating the incremental order of the categories: c("a", "b", "c"); a<b<c. Alphabetical order is assumed by default. Order is relevant for adjacent, cumulative and sequential ratio.}

\item{ref_category}{a string indicating the reference category. Proper option for models with reference ratio.}

\item{freedom_degrees}{an optional scalar to indicate the degrees of freedom for the Student distribution.}

\item{threshold}{restriction to impose on the thresholds, options are: standard or equidistant.}

\item{beta_init}{optional beta initialization vector.}
}
\description{
Family of models for categorical responses (reference, adjacent, sequential and cumulative ratio)
}
\examples{
data(DisturbedDreams)
ref_log_com <- GLMcat(formula = Level ~ Age, data = DisturbedDreams,
    ref_category = "Very.severe",
    distribution = "logistic", ratio = "reference")

}
