% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Uhat}
\alias{Uhat}
\title{Fast ranking function}
\usage{
Uhat(x)
}
\arguments{
\item{x}{A numeric matrix of observations to be ranked. Rows correspond to
features and columns to experiments.}
}
\value{
A matrix with the same dimensions as \code{x} of the scaled ranks.
}
\description{
Function for computing the scaled ranks for each column of the input matrix.
In other words, the values are ranked column-wise and divided by
\code{nrow(x) + 1}. A "1334" ranking scheme is used where the loweste values
is awarded rank 1, second lowest value rank 2, and ties are given the
maximum available rank.
}
\examples{
data <- SimulateGMMData()
par(mfrow = c(1,2))
plot(data$z, xlab = expression(z[1]), ylab = expression(z[2]))
plot(Uhat(data$z),
     xlab = expression(hat(u)[1]),
     ylab = expression(hat(u)[2]))
}
\author{
Anders Ellern Bilgrau (abilgrau@math.aau.dk)
}
\seealso{
\code{\link{SimulateGMMData}}, \code{\link{SimulateGMCMData}}
}

