% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Delta_rhodcca_test.R
\name{deltarhodcca.test}
\alias{deltarhodcca.test}
\title{Statistical test for Statistical test for Delta RHODCCA cross-correlation coefficient.}
\usage{
deltarhodcca.test(x, y, k, m, nu, rep)
}
\arguments{
\item{x}{A vector containing univariate time series.}

\item{y}{A vector containing univariate time series.}

\item{k}{An integer value indicating the boundary of the division \eqn{(N/k)}.
The smallest value of \eqn{k} is \eqn{4}.}

\item{m}{an integer value or a vector of integer values indicating the size of the window for the polinomial fit.}

\item{nu}{An integer value. See the DCCA package.}

\item{rep}{An integer value indicating the number of repetitions.}
}
\value{
An list containing "timescale", "mean", "sd", "rho_before", "rho_affter", "deltarho", "CI_0.90", "CI_0.95", "CI_0.99".
}
\description{
This function performs the statistical test for Delta RHODCCA cross-correlation coefficient from two univariate ARFIMA process.
}
\details{
This function include following measures: timescale, rho_before, rho_affter, deltarho
}
\examples{
x <- rnorm(1000)
y <-  rnorm(1000)
deltarhodcca.test(x,y,k=100,m=c(4:6),nu=0,rep=10)

}
\references{
Guedes, et al. Statistical test for DCCA cross-correlation coefficient, Physica A, v.501, 134-140, 2018.

Guedes, et al. Statistical test for DCCA: Methods and data, Data in Brief, v. 18, 795-798, 2018.
}
