% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.ts.bin.int.oc.r
\name{get.ts.bin.int.oc}
\alias{get.ts.bin.int.oc}
\title{Get two sample binary interim OC}
\usage{
get.ts.bin.int.oc(
  a.con = 1,
  b.con = 1,
  a.trt = 1,
  b.trt = 1,
  Delta.tv = 0.3,
  Delta.lrv = 0.2,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.65,
  go.thresh = 0.8,
  ng.thresh = 0.8,
  n.con = 40,
  n.trt = 40,
  n.int.c = c(10, 20, 30),
  n.int.t = c(10, 20, 30),
  DecisionTable = NULL,
  runs = 500,
  ControlRate = 0.2,
  TreatmentEffect = seq(0, 0.8, 0.1),
  include_nogo = TRUE
)
}
\arguments{
\item{a.con}{alpha parameter for control}

\item{b.con}{beta parameter for control}

\item{a.trt}{alpha parameter for treatment}

\item{b.trt}{beta parameter for treatment}

\item{Delta.tv}{Base TPP}

\item{Delta.lrv}{min TPP}

\item{tau.tv}{study-end threshold for Base TPP}

\item{tau.lrv}{study-end threshold for Min TPP}

\item{tau.ng}{study-end threshold for NG}

\item{go.thresh}{threshold for predictive probabilities at interim}

\item{ng.thresh}{threshold for predictive probabilities at interim}

\item{n.con}{final sample size for control}

\item{n.trt}{final sample size for treatment}

\item{n.int.c}{interim sample sizes for control}

\item{n.int.t}{interim sample sizes for treatment}

\item{DecisionTable}{results from get.ts.bin.int.dec}

\item{runs}{number of simulation runs}

\item{ControlRate}{assumed rate in the control group}

\item{TreatmentEffect}{vector of treatment effects relative to control group.}

\item{include_nogo}{logical}
}
\value{
dataframe of simulation results with the following columns:
* **Effect** the difference between the control Rate and treatment rate. (TreatmentRate = ControlRate + Effect)
* **run** the grouping variable by run.
* **assessment** the assessment in order, the last assessment is the final analysis results.
* **TreatmentEffect** The true response rate for the treatment group. (ControlRate is the same for all runs, it is not in the output, only the function input. We may want to change this for completeness, or include it in Param)
* **TotalResponse** for control (_C) and treatment(_T) respectively the total number of responses observed at that particular assessment. This is the cumulative sum over the assessments.
* **Decision** The decision at the assessment given the total response up to that point.  Note that the decision is calculated differently depending the assessment, the last assessment uses final assessment calculation while the earlier assessments use the interim assessment calculations.
}
\description{
Get two sample binary interim OC
}
\examples{
my.ts.bin.int.oc <-  get.ts.bin.int.oc()
head(my.ts.bin.int.oc)
}
