% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.tte.int.oc.df.r
\name{get.tte.int.oc.df}
\alias{get.tte.int.oc.df}
\title{Make time to event predictive probability OC curve}
\usage{
get.tte.int.oc.df(
  m.con.prior = 50,
  m.trt.prior = 50,
  HR.prior = 0.845,
  ARatio = 1,
  HR.lower = 0.0025,
  HR.upper = 2,
  npoints = 20,
  interim.m = c(428, 750, 1000),
  final.m = 1500,
  HR.tv = 0.75,
  HR.lrv = 0.9,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.65,
  n.MC = 2000,
  go.thresh = 0.8,
  ng.thresh = 0.8,
  include_nogo = TRUE
)
}
\arguments{
\item{m.con.prior}{prior number of events for control group}

\item{m.trt.prior}{prior number of events for treamtnet group}

\item{HR.prior}{hazard ratio estimate}

\item{ARatio}{Randomization ratio}

\item{HR.lower}{lower bound for HR}

\item{HR.upper}{upper bound for HR}

\item{npoints}{number of points for OC Curve}

\item{interim.m}{interim number of events}

\item{final.m}{final number of events}

\item{HR.tv}{Base TPP for HR}

\item{HR.lrv}{Min TPP for HR}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}

\item{n.MC}{Monte Carlo sample size}

\item{go.thresh}{predictive probability go threshold}

\item{ng.thresh}{predictive probability no-go threshold}

\item{include_nogo}{logical}
}
\value{
A data.frame is returned.
}
\description{
Make time to event predictive probability OC curve
}
\examples{
\donttest{
my.tte.int.oc.df <- get.tte.int.oc.df()
my.tte.int.oc.df
}
}
